/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.admin.service.SearchableStepExecutionDao;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.JdbcStepExecutionDao;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.batch.support.PatternMatcher;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcSearchableStepExecutionDao
extends JdbcStepExecutionDao
implements SearchableStepExecutionDao {
    private static final String STEP_EXECUTIONS_FOR_JOB = "SELECT distinct STEP_NAME from %PREFIX%STEP_EXECUTION S, %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where S.JOB_EXECUTION_ID = E.JOB_EXECUTION_ID AND E.JOB_INSTANCE_ID = I.JOB_INSTANCE_ID AND I.JOB_NAME = ?";
    private static final String COUNT_STEP_EXECUTIONS_FOR_STEP = "SELECT COUNT(STEP_EXECUTION_ID) from %PREFIX%STEP_EXECUTION S, %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where S.JOB_EXECUTION_ID = E.JOB_EXECUTION_ID AND E.JOB_INSTANCE_ID = I.JOB_INSTANCE_ID AND I.JOB_NAME = ? AND S.STEP_NAME = ?";
    private static final String COUNT_STEP_EXECUTIONS_FOR_STEP_PATTERN = "SELECT COUNT(STEP_EXECUTION_ID) from %PREFIX%STEP_EXECUTION S, %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where S.JOB_EXECUTION_ID = E.JOB_EXECUTION_ID AND E.JOB_INSTANCE_ID = I.JOB_INSTANCE_ID AND I.JOB_NAME = ? AND S.STEP_NAME like ?";
    private static final String FIELDS = "S.STEP_EXECUTION_ID, S.STEP_NAME, S.START_TIME, S.END_TIME, S.STATUS, S.COMMIT_COUNT, S.READ_COUNT, S.FILTER_COUNT, S.WRITE_COUNT, S.EXIT_CODE, S.EXIT_MESSAGE, S.READ_SKIP_COUNT, S.WRITE_SKIP_COUNT, S.PROCESS_SKIP_COUNT, S.ROLLBACK_COUNT, S.LAST_UPDATED, S.VERSION";
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource must be provided");
        if (this.getJdbcTemplate() == null) {
            this.setJdbcTemplate((SimpleJdbcOperations)new SimpleJdbcTemplate(this.dataSource));
        }
        this.setStepExecutionIncrementer((DataFieldMaxValueIncrementer)new AbstractDataFieldMaxValueIncrementer(){

            protected long getNextKey() {
                return 0L;
            }
        });
        super.afterPropertiesSet();
    }

    @Override
    public Collection<String> findStepNamesForJobExecution(String jobName, String excludesPattern) {
        List list = this.getJdbcTemplate().query(this.getQuery(STEP_EXECUTIONS_FOR_JOB), (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        }, new Object[]{jobName});
        LinkedHashSet<String> stepNames = new LinkedHashSet<String>(list);
        Iterator iterator = stepNames.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!PatternMatcher.match((String)excludesPattern, (String)name)) continue;
            iterator.remove();
        }
        return stepNames;
    }

    @Override
    public Collection<StepExecution> findStepExecutions(String jobName, String stepName, int start, int count) {
        List stepExecutions;
        String whereClause;
        if (jobName.contains("*")) {
            whereClause = "JOB_NAME like ?";
            jobName = jobName.replace("*", "%");
        } else {
            whereClause = "JOB_NAME = ?";
        }
        if (stepName.contains("*")) {
            whereClause = whereClause + " AND STEP_NAME like ?";
            stepName = stepName.replace("*", "%");
        } else {
            whereClause = whereClause + " AND STEP_NAME = ?";
        }
        PagingQueryProvider queryProvider = this.getPagingQueryProvider(whereClause);
        if (start <= 0) {
            stepExecutions = this.getJdbcTemplate().query(queryProvider.generateFirstPageQuery(count), (RowMapper)new StepExecutionRowMapper(), new Object[]{jobName, stepName});
        } else {
            try {
                Long startAfterValue = this.getJdbcTemplate().queryForLong(queryProvider.generateJumpToItemQuery(start, count), new Object[]{jobName, stepName});
                stepExecutions = this.getJdbcTemplate().query(queryProvider.generateRemainingPagesQuery(count), (RowMapper)new StepExecutionRowMapper(), new Object[]{jobName, stepName, startAfterValue});
            }
            catch (IncorrectResultSizeDataAccessException e) {
                return Collections.emptyList();
            }
        }
        return stepExecutions;
    }

    @Override
    public int countStepExecutions(String jobName, String stepName) {
        if (stepName.contains("*")) {
            return this.getJdbcTemplate().queryForInt(this.getQuery(COUNT_STEP_EXECUTIONS_FOR_STEP_PATTERN), new Object[]{jobName, stepName.replace("*", "%")});
        }
        return this.getJdbcTemplate().queryForInt(this.getQuery(COUNT_STEP_EXECUTIONS_FOR_STEP), new Object[]{jobName, stepName});
    }

    private PagingQueryProvider getPagingQueryProvider(String whereClause) {
        SqlPagingQueryProviderFactoryBean factory = new SqlPagingQueryProviderFactoryBean();
        factory.setDataSource(this.dataSource);
        factory.setFromClause(this.getQuery("%PREFIX%STEP_EXECUTION S, %PREFIX%JOB_EXECUTION J, %PREFIX%JOB_INSTANCE I"));
        factory.setSelectClause(FIELDS);
        factory.setSortKey("S.STEP_EXECUTION_ID");
        factory.setAscending(false);
        if (whereClause != null) {
            factory.setWhereClause(whereClause + " AND S.JOB_EXECUTION_ID = J.JOB_EXECUTION_ID AND J.JOB_INSTANCE_ID = I.JOB_INSTANCE_ID");
        }
        try {
            return (PagingQueryProvider)factory.getObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception creating paging query provide", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StepExecutionRowMapper
    implements RowMapper<StepExecution> {
        private StepExecutionRowMapper() {
        }

        public StepExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            StepExecution stepExecution = new StepExecution(rs.getString(2), null);
            stepExecution.setId(Long.valueOf(rs.getLong(1)));
            stepExecution.setStartTime((Date)rs.getTimestamp(3));
            stepExecution.setEndTime((Date)rs.getTimestamp(4));
            stepExecution.setStatus(BatchStatus.valueOf((String)rs.getString(5)));
            stepExecution.setCommitCount(rs.getInt(6));
            stepExecution.setReadCount(rs.getInt(7));
            stepExecution.setFilterCount(rs.getInt(8));
            stepExecution.setWriteCount(rs.getInt(9));
            stepExecution.setExitStatus(new ExitStatus(rs.getString(10), rs.getString(11)));
            stepExecution.setReadSkipCount(rs.getInt(12));
            stepExecution.setWriteSkipCount(rs.getInt(13));
            stepExecution.setProcessSkipCount(rs.getInt(14));
            stepExecution.setRollbackCount(rs.getInt(15));
            stepExecution.setLastUpdated((Date)rs.getTimestamp(16));
            stepExecution.setVersion(Integer.valueOf(rs.getInt(17)));
            return stepExecution;
        }
    }
}

