/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.launch;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
@ManagedResource
public class JobLauncherSynchronizer
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(JobLauncherSynchronizer.class);
    private JobExplorer jobExplorer;
    private JobRepository jobRepository;
    private Set<String> jobNames = new HashSet<String>();

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setJobNames(Set<String> jobNames) {
        this.jobNames = jobNames;
    }

    @ManagedOperation
    public void addJobName(String jobName) {
        this.jobNames.add(jobName);
    }

    @ManagedOperation
    public void removeJobName(String jobName) {
        this.jobNames.remove(jobName);
    }

    @ManagedAttribute
    public Set<String> getJobNames() {
        return this.jobNames;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobExplorer, (String)"A JobExplorer must be provided");
        Assert.notNull((Object)this.jobRepository, (String)"A JobRepository must be provided");
    }

    @Before(value="execution(* org.springframework.batch..JobLauncher+.*(..)) && args(job,..)")
    public void checkJobBeforeLaunch(Job job) throws JobExecutionAlreadyRunningException {
        String jobName = job.getName();
        logger.debug((Object)("Checking for synchronization on Job: " + jobName));
        if (!this.jobNames.contains(jobName)) {
            logger.debug((Object)("Not synchronizing Job: " + jobName));
            return;
        }
        Set running = this.jobExplorer.findRunningJobExecutions(jobName);
        if (!running.isEmpty()) {
            throw new JobExecutionAlreadyRunningException("An instance of this job is already active: " + jobName);
        }
        logger.debug((Object)("Job checked and no duplicates detected: " + jobName));
    }

    @AfterReturning(value="execution(* org.springframework.batch..JobRepository+.createJobExecution(..)) && args(jobName,..)", returning="jobExecution")
    public void checkJobDuringLaunch(String jobName, JobExecution jobExecution) throws JobExecutionAlreadyRunningException {
        logger.debug((Object)("Re-checking for synchronization on JobExecution: " + jobExecution));
        if (!this.jobNames.contains(jobName)) {
            logger.debug((Object)("Not re-checking for synchronization of Job: " + jobName));
            return;
        }
        Set running = this.jobExplorer.findRunningJobExecutions(jobName);
        if (running.size() > 1) {
            jobExecution.setEndTime(new Date());
            jobExecution.upgradeStatus(BatchStatus.ABANDONED);
            jobExecution.setExitStatus(jobExecution.getExitStatus().and(ExitStatus.NOOP).addExitDescription("Not executed because another execution was detected for the same Job."));
            this.jobRepository.update(jobExecution);
            throw new JobExecutionAlreadyRunningException("An instance of this job is already active: " + jobName);
        }
    }
}

