/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.admin.web.JobExecutionInfo;
import org.springframework.batch.admin.web.JobInfo;
import org.springframework.batch.admin.web.JobInstanceInfo;
import org.springframework.batch.admin.web.JobParametersExtractor;
import org.springframework.batch.admin.web.LaunchRequest;
import org.springframework.batch.admin.web.TableUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.HtmlUtils;

@Controller
public class JobController {
    private final JobService jobService;
    private Collection<String> extensions = new HashSet<String>();
    private TimeZone timeZone = TimeZone.getDefault();
    private JobParametersExtractor jobParametersExtractor = new JobParametersExtractor();

    public void setExtensions(Collection<String> extensions) {
        this.extensions = new LinkedHashSet<String>(extensions);
    }

    @Autowired(required=false)
    @Qualifier(value="userTimeZone")
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Autowired
    public JobController(JobService jobService) {
        this.jobService = jobService;
        this.extensions.addAll(Arrays.asList(".html", ".json", ".rss"));
    }

    @ModelAttribute(value="jobName")
    public String getJobName(HttpServletRequest request) {
        String path = request.getPathInfo();
        int index = path.lastIndexOf("jobs/") + 5;
        if (index >= 0) {
            path = path.substring(index);
        }
        if (!path.contains(".")) {
            return path;
        }
        for (String extension : this.extensions) {
            if (!path.endsWith(extension)) continue;
            path = StringUtils.stripFilenameExtension((String)path);
            break;
        }
        return path;
    }

    @RequestMapping(value={"/jobs/{jobName}"}, method={RequestMethod.POST})
    public String launch(ModelMap model, @ModelAttribute(value="jobName") String jobName, @ModelAttribute(value="launchRequest") LaunchRequest launchRequest, Errors errors, @RequestParam(defaultValue="execution") String origin) {
        launchRequest.setJobName(jobName);
        String params = launchRequest.jobParameters;
        JobParameters jobParameters = this.jobParametersExtractor.fromString(params);
        try {
            JobExecution jobExecution = this.jobService.launch(jobName, jobParameters);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
        }
        catch (NoSuchJobException e) {
            errors.reject("no.such.job", new Object[]{jobName}, "No such job: " + jobName);
        }
        catch (JobExecutionAlreadyRunningException e) {
            errors.reject("job.already.running", "A job with this name and parameters is already running.");
        }
        catch (JobRestartException e) {
            errors.reject("job.could.not.restart", "The job was not able to restart.");
        }
        catch (JobInstanceAlreadyCompleteException e) {
            errors.reject("job.already.complete", "A job with this name and parameters already completed successfully.");
        }
        catch (JobParametersInvalidException e) {
            errors.reject("job.parameters.invalid", "The job parameters are invalid according to the configuration.");
        }
        if (!"job".equals(origin)) {
            return "jobs/execution";
        }
        return this.details(model, jobName, errors, 0, 20);
    }

    @RequestMapping(value={"/jobs/{jobName}"}, method={RequestMethod.GET})
    public String details(ModelMap model, @ModelAttribute(value="jobName") String jobName, Errors errors, @RequestParam(defaultValue="0") int startJobInstance, @RequestParam(defaultValue="20") int pageSize) {
        boolean launchable = this.jobService.isLaunchable(jobName);
        try {
            Collection<JobInstance> result = this.jobService.listJobInstances(jobName, startJobInstance, pageSize);
            ArrayList<JobInstanceInfo> jobInstances = new ArrayList<JobInstanceInfo>();
            model.addAttribute("jobParameters", (Object)"");
            for (JobInstance jobInstance : result) {
                jobInstances.add(new JobInstanceInfo(jobInstance, this.jobService.getJobExecutionsForJobInstance(jobName, jobInstance.getId())));
            }
            model.addAttribute("jobInstances", jobInstances);
            int total = this.jobService.countJobInstances(jobName);
            TableUtils.addPagination((Map<String, Object>)model, total, startJobInstance, pageSize, "JobInstance");
            int count = this.jobService.countJobExecutionsForJob(jobName);
            model.addAttribute("jobInfo", (Object)new JobInfo(jobName, count, launchable, this.jobService.isIncrementable(jobName)));
        }
        catch (NoSuchJobException e) {
            errors.reject("no.such.job", new Object[]{jobName}, "There is no such job (" + HtmlUtils.htmlEscape((String)jobName) + ")");
        }
        return "jobs/job";
    }

    @RequestMapping(value={"/jobs"}, method={RequestMethod.GET})
    public void jobs(ModelMap model, @RequestParam(defaultValue="0") int startJob, @RequestParam(defaultValue="20") int pageSize) {
        int total = this.jobService.countJobs();
        TableUtils.addPagination((Map<String, Object>)model, total, startJob, pageSize, "Job");
        Collection<String> names = this.jobService.listJobs(startJob, pageSize);
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
        for (String name : names) {
            int count = 0;
            try {
                count = this.jobService.countJobExecutionsForJob(name);
            }
            catch (NoSuchJobException e) {
                // empty catch block
            }
            boolean launchable = this.jobService.isLaunchable(name);
            boolean incrementable = this.jobService.isIncrementable(name);
            jobs.add(new JobInfo(name, count, null, launchable, incrementable));
        }
        model.addAttribute("jobs", jobs);
    }
}

