/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.admin.domain.JobInfo;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.GenericApplicationContextFactory;
import org.springframework.batch.core.configuration.support.JobLoader;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class JobConfigurationResourceLoader
implements ApplicationContextAware {
    private JobLoader jobLoader;
    private JobService jobService;
    private ApplicationContext parent;

    public void setJobLoader(JobLoader jobLoader) {
        this.jobLoader = jobLoader;
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parent = applicationContext;
    }

    @ServiceActivator
    public Collection<JobInfo> loadJobs(Resource resource) throws DuplicateJobException {
        ArrayList<JobInfo> result = new ArrayList<JobInfo>();
        ApplicationContextFactory factory = this.createApplicationContextFactory(this.parent, resource);
        Collection jobs = this.jobLoader.reload(factory);
        for (Job job : jobs) {
            String name = job.getName();
            int count = 0;
            try {
                count = this.jobService.countJobExecutionsForJob(name);
            }
            catch (NoSuchJobException e) {
                // empty catch block
            }
            boolean launchable = this.jobService.isLaunchable(name);
            boolean incrementable = this.jobService.isIncrementable(name);
            result.add(new JobInfo(name, count, null, launchable, incrementable));
        }
        return result;
    }

    protected ApplicationContextFactory createApplicationContextFactory(ApplicationContext parent, Resource resource) {
        GenericApplicationContextFactory applicationContextFactory = new GenericApplicationContextFactory(new Object[]{resource});
        if (parent != null) {
            applicationContextFactory.setApplicationContext(parent);
        }
        return applicationContextFactory;
    }
}

