/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class SessionIdFilter
extends OncePerRequestFilter {
    private static final String JSESSIONID_PATTERN = ";[jJ][sS][eE][sS][sS][iI][oO][nN][iI][dD]=[A-Za-z0-9]+";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.bounceRequestWithSessionIdInUrl(request, response)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)new EnhancedResponseWrapper(response));
        }
    }

    private boolean bounceRequestWithSessionIdInUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = request.getRequestURL().toString();
        if (url.matches("(.*);[jJ][sS][eE][sS][sS][iI][oO][nN][iI][dD]=[A-Za-z0-9]+(.*)")) {
            String queryString = request.getQueryString();
            url = url.replaceAll(JSESSIONID_PATTERN, "") + (StringUtils.hasText((String)queryString) ? "?" + queryString : "");
            response.sendRedirect(url);
            return true;
        }
        return false;
    }

    private static class EnhancedResponseWrapper
    extends HttpServletResponseWrapper {
        public EnhancedResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public String encodeRedirectUrl(String url) {
            return this.encodeRedirectURL(url);
        }

        public String encodeRedirectURL(String url) {
            String encoded = super.encodeRedirectURL(url);
            return this.stripSessionId(encoded);
        }

        public String encodeUrl(String url) {
            return this.encodeURL(url);
        }

        public String encodeURL(String url) {
            String encoded = super.encodeURL(url);
            return this.stripSessionId(encoded);
        }

        private String stripSessionId(String encoded) {
            return encoded.replaceAll(SessionIdFilter.JSESSIONID_PATTERN, "");
        }
    }
}

