/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.interceptor;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTypeInterceptor
extends HandlerInterceptorAdapter
implements BeanFactoryAware {
    private Collection<String> extensions = new HashSet<String>();
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setExtensions(Collection<String> extensions) {
        this.extensions = new LinkedHashSet<String>(extensions);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String scheme = request.getScheme();
        StringBuffer url = new StringBuffer(scheme + "://");
        url.append(request.getServerName());
        int port = request.getServerPort();
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(":" + port);
        }
        request.setAttribute("baseUrl", (Object)url.toString());
        request.setAttribute("currentTime", (Object)new Date());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView == null) {
            return;
        }
        String path = WebUtils.extractFullFilenameFromUrlPath((String)request.getPathInfo());
        if (!path.contains(".")) {
            return;
        }
        String extension = path.substring(path.lastIndexOf(".") + 1);
        this.exposeErrors(modelAndView.getModelMap());
        if (this.extensions.contains(extension) && modelAndView.isReference()) {
            String viewName = modelAndView.getViewName();
            if (viewName.contains(".")) {
                viewName = viewName.substring(0, path.lastIndexOf("."));
            }
            String newViewName = viewName + "." + extension;
            if (this.beanFactory == null || this.beanFactory.containsBean(newViewName)) {
                modelAndView.setViewName(newViewName);
            }
        }
    }

    private void exposeErrors(ModelMap modelMap) {
        if (modelMap.containsAttribute("errors")) {
            return;
        }
        BindException errors = new BindException(new Object(), "target");
        boolean hasErrors = false;
        for (Object value : modelMap.values()) {
            if (!(value instanceof Errors)) continue;
            for (ObjectError error : ((Errors)value).getGlobalErrors()) {
                errors.addError(error);
                hasErrors = true;
            }
        }
        if (hasErrors) {
            modelMap.addAttribute("errors", (Object)errors);
        }
    }
}

