/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ExecutionContextUserSupport;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.MarkFailedException;
import org.springframework.batch.item.NoWorkFoundException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.ResetFailedException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.SQLWarningException;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JdbcCursorItemReader
extends ExecutionContextUserSupport
implements ItemReader,
InitializingBean,
ItemStream {
    private static Log log = LogFactory.getLog((Class)JdbcCursorItemReader.class);
    public static final int VALUE_NOT_SET = -1;
    private static final String CURRENT_PROCESSED_ROW = "last.processed.row.number";
    private Connection con;
    private PreparedStatement preparedStatement;
    private PreparedStatementSetter preparedStatementSetter;
    protected ResultSet rs;
    private DataSource dataSource;
    private String sql;
    private int fetchSize = -1;
    private int maxRows = -1;
    private int queryTimeout = -1;
    private boolean ignoreWarnings = true;
    private boolean verifyCursorPosition = true;
    private SQLExceptionTranslator exceptionTranslator;
    private RowMapper mapper;
    private boolean initialized = false;
    private boolean saveState = false;
    private BufferredResultSetReader bufferredReader;

    public JdbcCursorItemReader() {
        this.setName(ClassUtils.getShortName((Class)JdbcCursorItemReader.class));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"DataSOurce must be provided");
        Assert.notNull((Object)this.sql, (String)"The SQL query must be provided");
        Assert.notNull((Object)this.mapper, (String)"RowMapper must be provided");
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Object read() throws Exception {
        return this.bufferredReader.read();
    }

    public long getCurrentProcessedRow() {
        return this.bufferredReader.getProcessedRowCount();
    }

    public void mark() {
        this.bufferredReader.mark();
    }

    public void reset() throws ResetFailedException {
        this.bufferredReader.reset();
    }

    public void close(ExecutionContext executionContext) {
        this.initialized = false;
        JdbcUtils.closeResultSet((ResultSet)this.rs);
        JdbcUtils.closeStatement((Statement)this.preparedStatement);
        JdbcUtils.closeConnection((Connection)this.con);
        this.bufferredReader = null;
        this.rs = null;
    }

    private void executeQuery() {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource must not be null.");
        try {
            this.con = this.dataSource.getConnection();
            this.preparedStatement = this.con.prepareStatement(this.sql, 1003, 1007, 1);
            this.applyStatementSettings(this.preparedStatement);
            if (this.preparedStatementSetter != null) {
                this.preparedStatementSetter.setValues(this.preparedStatement);
            }
            this.rs = this.preparedStatement.executeQuery();
            this.handleWarnings(this.preparedStatement.getWarnings());
        }
        catch (SQLException se) {
            this.close(null);
            throw this.getExceptionTranslator().translate("Executing query", this.sql, se);
        }
    }

    private void applyStatementSettings(PreparedStatement stmt) throws SQLException {
        if (this.fetchSize != -1) {
            stmt.setFetchSize(this.fetchSize);
            stmt.setFetchDirection(1000);
        }
        if (this.maxRows != -1) {
            stmt.setMaxRows(this.maxRows);
        }
        if (this.queryTimeout != -1) {
            stmt.setQueryTimeout(this.queryTimeout);
        }
    }

    protected SQLExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            this.exceptionTranslator = this.dataSource != null ? new SQLErrorCodeSQLExceptionTranslator(this.dataSource) : new SQLStateSQLExceptionTranslator();
        }
        return this.exceptionTranslator;
    }

    private void handleWarnings(SQLWarning warnings) throws SQLWarningException {
        if (this.ignoreWarnings) {
            for (SQLWarning warningToLog = warnings; warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                log.debug((Object)("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "]"));
            }
        } else if (warnings != null) {
            throw new SQLWarningException("Warning not ignored", warnings);
        }
    }

    public void update(ExecutionContext executionContext) {
        if (this.saveState && this.initialized) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            executionContext.putLong(this.getKey(CURRENT_PROCESSED_ROW), this.bufferredReader.getProcessedRowCount());
        }
    }

    public void open(ExecutionContext context) {
        Assert.state((!this.initialized ? 1 : 0) != 0, (String)"Stream is already initialized.  Close before re-opening.");
        Assert.isNull((Object)this.rs, (String)"ResultSet still open!  Close before re-opening.");
        Assert.notNull((Object)context, (String)"ExecutionContext must not be null");
        this.executeQuery();
        this.initialized = true;
        int processedRowCount = 0;
        if (context.containsKey(this.getKey(CURRENT_PROCESSED_ROW))) {
            try {
                processedRowCount = Long.valueOf(context.getLong(this.getKey(CURRENT_PROCESSED_ROW))).intValue();
                int count = 0;
                while (this.rs.next() && ++count != processedRowCount) {
                }
            }
            catch (SQLException se) {
                throw this.getExceptionTranslator().translate("Attempted to move ResultSet to last committed row", this.sql, se);
            }
        }
        this.bufferredReader = new BufferredResultSetReader(this.rs, this.mapper, processedRowCount);
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public void setVerifyCursorPosition(boolean verifyCursorPosition) {
        this.verifyCursorPosition = verifyCursorPosition;
    }

    public void setMapper(RowMapper mapper) {
        this.mapper = mapper;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setPreparedStatementSetter(PreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    private class BufferredResultSetReader
    implements ItemReader {
        private ResultSet rs;
        private RowMapper rowMapper;
        private List buffer;
        private int currentIndex;
        private int processedRowCount;
        private int INITIAL_POSITION = -1;

        public BufferredResultSetReader(ResultSet rs, RowMapper rowMapper, int processedRowCount) {
            Assert.notNull((Object)rs, (String)"The ResultSet must not be null");
            Assert.notNull((Object)rowMapper, (String)"The RowMapper must not be null");
            this.rs = rs;
            this.rowMapper = rowMapper;
            this.buffer = new ArrayList();
            this.currentIndex = this.INITIAL_POSITION;
            this.processedRowCount = processedRowCount;
        }

        public BufferredResultSetReader(ResultSet rs, RowMapper rowMapper) {
            this(rs, rowMapper, 0);
        }

        public Object read() throws Exception, UnexpectedInputException, NoWorkFoundException, ParseException {
            ++this.currentIndex;
            if (this.buffer.size() == this.currentIndex) {
                try {
                    if (!this.rs.next()) {
                        return null;
                    }
                    int currentRow = this.processedRowCount + 1;
                    this.buffer.add(this.rowMapper.mapRow(this.rs, currentRow));
                    this.verifyCursorPosition(currentRow);
                }
                catch (SQLException se) {
                    throw JdbcCursorItemReader.this.getExceptionTranslator().translate("Attempt to process next row failed", JdbcCursorItemReader.this.sql, se);
                }
            }
            ++this.processedRowCount;
            return this.buffer.get(this.currentIndex);
        }

        public void mark() throws MarkFailedException {
            this.buffer.clear();
            this.currentIndex = this.INITIAL_POSITION;
        }

        public void reset() throws ResetFailedException {
            this.processedRowCount -= this.buffer.size();
            this.currentIndex = this.INITIAL_POSITION;
        }

        private void verifyCursorPosition(long expectedCurrentRow) throws SQLException {
            if (JdbcCursorItemReader.this.verifyCursorPosition && expectedCurrentRow != (long)this.rs.getRow()) {
                throw new InvalidDataAccessResourceUsageException("Unexpected cursor position change.");
            }
        }

        public long getProcessedRowCount() {
            return this.processedRowCount;
        }
    }
}

