/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ExecutionContextUserSupport;
import org.springframework.batch.item.database.KeyCollector;
import org.springframework.orm.ibatis.SqlMapClientTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class IbatisKeyCollector
extends ExecutionContextUserSupport
implements KeyCollector {
    private static final String RESTART_KEY = "key.index";
    private SqlMapClientTemplate sqlMapClientTemplate;
    private String drivingQuery;
    private String restartQueryId;

    public IbatisKeyCollector() {
        this.setName(ClassUtils.getShortName((Class)IbatisKeyCollector.class));
    }

    public List retrieveKeys(ExecutionContext executionContext) {
        if (executionContext.containsKey(this.getKey(RESTART_KEY))) {
            Object key = executionContext.get(this.getKey(RESTART_KEY));
            return this.sqlMapClientTemplate.queryForList(this.restartQueryId, key);
        }
        return this.sqlMapClientTemplate.queryForList(this.drivingQuery);
    }

    public void updateContext(Object key, ExecutionContext executionContext) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)executionContext, (String)"ExecutionContext must be null");
        executionContext.put(this.getKey(RESTART_KEY), key);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sqlMapClientTemplate, (String)"SqlMaperClientTemplate must not be null.");
        Assert.hasText((String)this.drivingQuery, (String)"The DrivingQuery must not be null or empty.");
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClientTemplate = new SqlMapClientTemplate();
        this.sqlMapClientTemplate.setSqlMapClient(sqlMapClient);
    }

    public void setDrivingQueryId(String drivingQueryId) {
        this.drivingQuery = drivingQueryId;
    }

    public void setRestartQueryId(String restartQueryId) {
        this.restartQueryId = restartQueryId;
    }

    public final SqlMapClientTemplate getSqlMapClientTemplate() {
        return this.sqlMapClientTemplate;
    }
}

