/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ExecutionContextUserSupport;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.item.database.KeyCollector;
import org.springframework.batch.item.database.support.ColumnMapItemPreparedStatementSetter;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MultipleColumnJdbcKeyCollector
extends ExecutionContextUserSupport
implements KeyCollector {
    private static final String CURRENT_KEY = "current.key";
    private JdbcTemplate jdbcTemplate;
    private RowMapper keyMapper = new ColumnMapRowMapper();
    private ItemPreparedStatementSetter preparedStatementSetter = new ColumnMapItemPreparedStatementSetter();
    private String sql;
    private String restartSql;

    public MultipleColumnJdbcKeyCollector() {
        this.setName(ClassUtils.getShortName((Class)MultipleColumnJdbcKeyCollector.class));
    }

    public MultipleColumnJdbcKeyCollector(JdbcTemplate jdbcTemplate, String sql) {
        this();
        Assert.notNull((Object)jdbcTemplate, (String)"The JdbcTemplate must not be null.");
        Assert.hasText((String)sql, (String)"The sql statement must not be null or empty.");
        this.jdbcTemplate = jdbcTemplate;
        this.sql = sql;
    }

    public List retrieveKeys(ExecutionContext executionContext) {
        Assert.state((this.keyMapper != null ? 1 : 0) != 0, (String)"KeyMapper must not be null.");
        Assert.state((boolean)StringUtils.hasText((String)this.restartSql), (String)"The RestartQuery must not be null or empty in order to restart.");
        if (executionContext.size() > 0) {
            Object key = executionContext.get(this.getKey(CURRENT_KEY));
            return this.jdbcTemplate.query(this.restartSql, (PreparedStatementSetter)new PreparedStatementSetterKeyWrapper(key, this.preparedStatementSetter), this.keyMapper);
        }
        return this.jdbcTemplate.query(this.sql, this.keyMapper);
    }

    public void updateContext(Object key, ExecutionContext executionContext) {
        Assert.notNull((Object)key, (String)"The key must not be null");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null");
        executionContext.put(this.getKey(CURRENT_KEY), key);
    }

    public void setRestartSql(String restartQuery) {
        this.restartSql = restartQuery;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jdbcTemplate, (String)"The JdbcTemplate must not be null.");
        Assert.hasText((String)this.sql, (String)"The DrivingQuery must not be null or empty.");
        Assert.notNull((Object)this.keyMapper, (String)"The key RowMapper must not be null.");
    }

    public void setKeyMapper(RowMapper keyMapper) {
        this.keyMapper = keyMapper;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setPreparedStatementSetter(ItemPreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
    }

    private static class PreparedStatementSetterKeyWrapper
    implements PreparedStatementSetter {
        private Object key;
        private ItemPreparedStatementSetter pss;

        public PreparedStatementSetterKeyWrapper(Object key, ItemPreparedStatementSetter pss) {
            this.key = key;
            this.pss = pss;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            this.pss.setValues(this.key, ps);
        }
    }
}

