/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.file.transform.AbstractLineTokenizer;
import org.springframework.batch.item.file.transform.Range;

public class FixedLengthTokenizer
extends AbstractLineTokenizer {
    private Range[] ranges;

    public void setColumns(Range[] ranges) {
        this.ranges = ranges;
    }

    protected List doTokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>(this.ranges.length);
        int lineLength = line.length();
        for (int i = 0; i < this.ranges.length; ++i) {
            int startPos = this.ranges[i].getMin() - 1;
            int endPos = this.ranges[i].getMax();
            String token = lineLength >= endPos ? line.substring(startPos, endPos) : (lineLength >= startPos ? line.substring(startPos) : "");
            tokens.add(token);
        }
        return tokens;
    }
}

