/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.AbstractItemReader;
import org.springframework.batch.item.FailedItemIdentifier;
import org.springframework.batch.item.ItemKeyGenerator;
import org.springframework.batch.item.ItemRecoverer;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsOperations;
import org.springframework.util.Assert;

public class JmsItemReader
extends AbstractItemReader
implements ItemRecoverer,
ItemKeyGenerator,
FailedItemIdentifier {
    protected Log logger = LogFactory.getLog(this.getClass());
    private JmsOperations jmsTemplate;
    private Class itemType;
    private String errorDestinationName;
    private Destination errorDestination;

    public void setErrorDestination(Destination errorDestination) {
        this.errorDestination = errorDestination;
    }

    public void setErrorDestinationName(String errorDestinationName) {
        this.errorDestinationName = errorDestinationName;
    }

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setItemType(Class itemType) {
        this.itemType = itemType;
    }

    public Object read() {
        if (this.itemType != null && this.itemType.isAssignableFrom(Message.class)) {
            return this.jmsTemplate.receive();
        }
        Object result = this.jmsTemplate.receiveAndConvert();
        if (this.itemType != null && result != null) {
            Assert.state((boolean)this.itemType.isAssignableFrom(result.getClass()), (String)("Received message payload of wrong type: expected [" + this.itemType + "]"));
        }
        return result;
    }

    public boolean recover(Object item, Throwable cause) {
        try {
            if (this.errorDestination != null) {
                this.jmsTemplate.convertAndSend(this.errorDestination, item);
            } else if (this.errorDestinationName != null) {
                this.jmsTemplate.convertAndSend(this.errorDestinationName, item);
            } else {
                return false;
            }
            return true;
        }
        catch (JmsException e) {
            this.logger.error((Object)"Could not recover because of JmsException.", (Throwable)e);
            return false;
        }
    }

    public Object getKey(Object item) {
        if (this.itemType != null && this.itemType.isAssignableFrom(Message.class)) {
            try {
                return ((Message)item).getJMSMessageID();
            }
            catch (JMSException e) {
                throw new UnexpectedInputException("Could not extract message ID", e);
            }
        }
        return item;
    }

    public boolean hasFailed(Object item) {
        if (this.itemType != null && this.itemType.isAssignableFrom(Message.class)) {
            try {
                return ((Message)item).getJMSRedelivered();
            }
            catch (JMSException e) {
                throw new UnexpectedInputException("Could not extract message ID", e);
            }
        }
        return true;
    }
}

