/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ExecutionContextUserSupport;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.util.FileUtils;
import org.springframework.batch.item.xml.EventWriterSerializer;
import org.springframework.batch.item.xml.stax.NoStartEndDocumentStreamWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class StaxEventItemWriter
extends ExecutionContextUserSupport
implements ItemWriter,
ItemStream,
InitializingBean {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_XML_VERSION = "1.0";
    private static final String DEFAULT_ROOT_TAG_NAME = "root";
    private static final String RESTART_DATA_NAME = "position";
    private static final String WRITE_STATISTICS_NAME = "record.count";
    private Resource resource;
    private EventWriterSerializer serializer;
    private String encoding = "UTF-8";
    private String version = "1.0";
    private String rootTagName = "root";
    private Map rootElementAttributes = null;
    private boolean restarted = false;
    private boolean overwriteOutput = true;
    private FileChannel channel;
    private XMLEventWriter eventWriter;
    private XMLEventWriter delegateEventWriter;
    private long lastCommitPointPosition = 0L;
    private long lastCommitPointRecordCount = 0L;
    private long currentRecordCount = 0L;
    private boolean saveState = false;
    private List buffer = new ArrayList();

    public StaxEventItemWriter() {
        this.setName(ClassUtils.getShortName((Class)StaxEventItemWriter.class));
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setSerializer(EventWriterSerializer serializer) {
        this.serializer = serializer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRootTagName() {
        return this.rootTagName;
    }

    public void setRootTagName(String rootTagName) {
        this.rootTagName = rootTagName;
    }

    public Map getRootElementAttributes() {
        return this.rootElementAttributes;
    }

    public void setRootElementAttributes(Map rootElementAttributes) {
        this.rootElementAttributes = rootElementAttributes;
    }

    public void setOverwriteOutput(boolean overwriteOutput) {
        this.overwriteOutput = overwriteOutput;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resource);
        Assert.notNull((Object)this.serializer);
    }

    public void open(ExecutionContext executionContext) {
        long startAtPosition = 0L;
        if (executionContext.containsKey(this.getKey(RESTART_DATA_NAME))) {
            startAtPosition = executionContext.getLong(this.getKey(RESTART_DATA_NAME));
            this.restarted = true;
        }
        this.open(startAtPosition);
    }

    private void open(long position) {
        FileOutputStream os = null;
        try {
            File file = this.resource.getFile();
            FileUtils.setUpOutputFile(file, this.restarted, this.overwriteOutput);
            os = new FileOutputStream(file, true);
            this.channel = os.getChannel();
            this.setPosition(position);
        }
        catch (IOException ioe) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + this.resource + "]", (Throwable)ioe);
        }
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            this.delegateEventWriter = outputFactory.createXMLEventWriter(os, this.encoding);
            this.eventWriter = new NoStartEndDocumentStreamWriter(this.delegateEventWriter);
            if (!this.restarted) {
                this.startDocument(this.delegateEventWriter);
            }
        }
        catch (XMLStreamException xse) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + this.resource + "]", (Throwable)xse);
        }
    }

    private void startDocument(XMLEventWriter writer) throws XMLStreamException {
        XMLEventFactory factory = XMLEventFactory.newInstance();
        writer.add(factory.createStartDocument(this.getEncoding(), this.getVersion()));
        writer.add(factory.createStartElement("", "", this.getRootTagName()));
        if (!CollectionUtils.isEmpty((Map)this.getRootElementAttributes())) {
            Iterator i = this.getRootElementAttributes().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                writer.add(factory.createAttribute((String)entry.getKey(), (String)entry.getValue()));
            }
        }
    }

    private void endDocument(XMLEventWriter writer) throws XMLStreamException {
        XMLEventFactory factory = XMLEventFactory.newInstance();
        writer.add(factory.createCharacters(""));
        writer.flush();
        ByteBuffer bbuf = ByteBuffer.wrap(("</" + this.getRootTagName() + ">").getBytes());
        try {
            this.channel.write(bbuf);
        }
        catch (IOException ioe) {
            throw new DataAccessResourceFailureException("Unable to close file resource: [" + this.resource + "]", (Throwable)ioe);
        }
    }

    public void close(ExecutionContext executionContext) {
        this.flush();
        try {
            this.endDocument(this.delegateEventWriter);
            this.eventWriter.close();
            this.channel.close();
        }
        catch (XMLStreamException xse) {
            throw new DataAccessResourceFailureException("Unable to close file resource: [" + this.resource + "]", (Throwable)xse);
        }
        catch (IOException ioe) {
            throw new DataAccessResourceFailureException("Unable to close file resource: [" + this.resource + "]", (Throwable)ioe);
        }
    }

    public void write(Object item) {
        ++this.currentRecordCount;
        this.buffer.add(item);
    }

    public void update(ExecutionContext executionContext) {
        if (this.saveState) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            executionContext.putLong(this.getKey(RESTART_DATA_NAME), this.getPosition());
            executionContext.putLong(this.getKey(WRITE_STATISTICS_NAME), this.currentRecordCount);
        }
    }

    private long getPosition() {
        long position;
        try {
            this.eventWriter.flush();
            position = this.channel.position();
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + this.resource + "]", (Throwable)e);
        }
        return position;
    }

    private void setPosition(long newPosition) {
        try {
            Assert.state((this.channel.size() >= this.lastCommitPointPosition ? 1 : 0) != 0, (String)"Current file size is smaller than size at last commit");
            this.channel.truncate(newPosition);
            this.channel.position(newPosition);
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("Unable to write to file resource: [" + this.resource + "]", (Throwable)e);
        }
    }

    public void flush() throws FlushFailedException {
        ListIterator iterator = this.buffer.listIterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            this.serializer.serializeObject(this.eventWriter, item);
        }
        this.buffer.clear();
        this.lastCommitPointPosition = this.getPosition();
        this.lastCommitPointRecordCount = this.currentRecordCount;
    }

    public void clear() throws ClearFailedException {
        this.currentRecordCount = this.lastCommitPointRecordCount;
        this.buffer.clear();
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }
}

