/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import org.springframework.batch.repeat.RepeatException;
import org.springframework.batch.repeat.support.RepeatInternalStateSupport;
import org.springframework.batch.repeat.support.ResultHolder;
import org.springframework.batch.repeat.support.ResultQueue;

abstract class AbstractResultQueue
extends RepeatInternalStateSupport
implements ResultQueue {
    Object lock = new Object();
    Object hold = new Object();
    volatile int count = 0;

    AbstractResultQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpecting() {
        Object object = this.lock;
        synchronized (object) {
            return this.count > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expect() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.aquireWait();
                ++this.count;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RepeatException("InterruptedException waiting for to acquire lock on input.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ResultHolder holder) {
        Object object = this.hold;
        synchronized (object) {
            this.addResult(holder);
            this.releaseWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultHolder take() {
        ResultHolder value;
        try {
            Object object = this.lock;
            synchronized (object) {
                value = this.takeResult();
                --this.count;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RepeatException("InterruptedException while waiting for result.");
        }
        return value;
    }

    protected abstract void aquireWait() throws InterruptedException;

    protected abstract void releaseWait();

    protected abstract void addResult(ResultHolder var1);

    protected abstract ResultHolder takeResult() throws InterruptedException;
}

