/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.TerminatedRetryException;
import org.springframework.batch.retry.context.RetryContextSupport;
import org.springframework.batch.retry.policy.AbstractStatelessRetryPolicy;

public class NeverRetryPolicy
extends AbstractStatelessRetryPolicy {
    public boolean canRetry(RetryContext context) {
        return !((NeverRetryContext)context).isFinished();
    }

    public void close(RetryContext context) {
    }

    public RetryContext open(RetryCallback callback, RetryContext parent) {
        return new NeverRetryContext(parent);
    }

    public void registerThrowable(RetryContext context, Throwable throwable) throws TerminatedRetryException {
        ((NeverRetryContext)context).setFinished();
        ((RetryContextSupport)context).registerThrowable(throwable);
    }

    private static class NeverRetryContext
    extends RetryContextSupport {
        private boolean finished = false;

        public NeverRetryContext(RetryContext parent) {
            super(parent);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished() {
            this.finished = true;
        }
    }
}

