/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.batch.item.transform.ItemTransformer;

public class RecursiveCollectionItemTransformer
implements ItemTransformer {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ItemTransformer delegate = new ItemTransformer(){

        public Object transform(Object item) throws Exception {
            return item;
        }
    };

    public void setDelegate(ItemTransformer delegate) {
        this.delegate = delegate;
    }

    public Object transform(Object input) throws Exception {
        TransformHolder holder = new TransformHolder();
        this.transformRecursively(input, holder);
        String result = holder.builder.toString();
        return result.substring(0, result.lastIndexOf(LINE_SEPARATOR));
    }

    public String stringify(Object item) throws Exception {
        return "" + this.delegate.transform(item);
    }

    private void transformRecursively(Object data, TransformHolder converted) throws Exception {
        if (data instanceof Collection) {
            Iterator iterator = ((Collection)data).iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                this.transformRecursively(value, new TransformHolder(converted.builder));
            }
            return;
        }
        if (data.getClass().isArray()) {
            Object[] array = (Object[])data;
            for (int i = 0; i < array.length; ++i) {
                Object value = array[i];
                this.transformRecursively(value, new TransformHolder(converted.builder));
            }
            return;
        }
        if (!(data instanceof String)) {
            this.transformRecursively(this.stringify(data), converted);
            return;
        }
        converted.builder.append(data + LINE_SEPARATOR);
    }

    private static class TransformHolder {
        StringBuffer builder = new StringBuffer();

        TransformHolder() {
        }

        TransformHolder(StringBuffer builder) {
            this.builder = builder;
        }
    }
}

