/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatListener;

public class CompositeRepeatListener
implements RepeatListener {
    private List listeners = new ArrayList();

    public void setListeners(RepeatListener[] listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public void register(RepeatListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void after(RepeatContext context, ExitStatus result) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            RepeatListener listener = (RepeatListener)iterator.next();
            listener.after(context, result);
        }
    }

    public void before(RepeatContext context) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            RepeatListener listener = (RepeatListener)iterator.next();
            listener.before(context);
        }
    }

    public void close(RepeatContext context) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            RepeatListener listener = (RepeatListener)iterator.next();
            listener.close(context);
        }
    }

    public void onError(RepeatContext context, Throwable e) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            RepeatListener listener = (RepeatListener)iterator.next();
            listener.onError(context, e);
        }
    }

    public void open(RepeatContext context) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            RepeatListener listener = (RepeatListener)iterator.next();
            listener.open(context);
        }
    }
}

