/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import org.springframework.batch.repeat.support.BackportConcurrentResultQueue;
import org.springframework.batch.repeat.support.JdkConcurrentResultQueue;
import org.springframework.batch.repeat.support.RepeatInternalState;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;

class ResultQueueFactory {
    private static final boolean backportConcurrentAvailable = ClassUtils.isPresent((String)"edu.emory.mathcs.backport.java.util.concurrent.Semaphore", (ClassLoader)ResultQueueFactory.class.getClassLoader());

    ResultQueueFactory() {
    }

    public RepeatInternalState getResultQueue(int throttleLimit) {
        if (JdkVersion.isAtLeastJava15()) {
            return new JdkConcurrentResultQueue(throttleLimit);
        }
        if (backportConcurrentAvailable) {
            return new BackportConcurrentResultQueue(throttleLimit);
        }
        throw new IllegalStateException("Cannot create ResultQueue - neither JDK 1.5 nor backport-concurrent available on the classpath");
    }
}

