/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.support.DelegatingItemReader;

public class AggregateItemReader
extends DelegatingItemReader {
    private static final Log log = LogFactory.getLog((Class)AggregateItemReader.class);
    public static final Object END_RECORD = new Object();
    public static final Object BEGIN_RECORD = new Object();

    public Object read() throws Exception {
        ResultHolder holder = new ResultHolder();
        while (this.process(super.read(), holder)) {
        }
        if (!holder.exhausted) {
            return holder.records;
        }
        return null;
    }

    private boolean process(Object value, ResultHolder holder) {
        if (value == null) {
            log.debug((Object)"Exhausted ItemReader");
            holder.exhausted = true;
            return false;
        }
        if (value == BEGIN_RECORD) {
            log.debug((Object)"Start of new record detected");
            return true;
        }
        if (value == END_RECORD) {
            log.debug((Object)"End of record detected");
            return false;
        }
        log.debug((Object)("Mapping: " + value));
        holder.records.add(value);
        return true;
    }

    private static class ResultHolder {
        Collection records = new ArrayList();
        boolean exhausted = false;

        private ResultHolder() {
        }
    }
}

