/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.support.RepeatInternalState;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.ResultHolder;
import org.springframework.batch.repeat.support.ResultQueue;
import org.springframework.batch.repeat.support.ResultQueueFactory;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class TaskExecutorRepeatTemplate
extends RepeatTemplate {
    public static final int DEFAULT_THROTTLE_LIMIT = 4;
    private int throttleLimit = 4;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor);
        this.taskExecutor = taskExecutor;
    }

    protected ExitStatus getNextResult(RepeatContext context, RepeatCallback callback, RepeatInternalState state) throws Throwable {
        ExecutingRunnable runnable = null;
        ResultQueue queue = (ResultQueue)state;
        do {
            runnable = new ExecutingRunnable(callback, context, queue);
            runnable.expect();
            this.taskExecutor.execute((Runnable)runnable);
            this.update(context);
        } while (queue.isEmpty() && !this.isComplete(context));
        ResultHolder result = queue.take();
        if (result.getError() != null) {
            throw result.getError();
        }
        return result.getResult();
    }

    protected boolean waitForResults(RepeatInternalState state) {
        ResultQueue queue = (ResultQueue)state;
        boolean result = true;
        while (queue.isExpecting()) {
            ResultHolder future = queue.take();
            if (future.getError() != null) {
                state.getThrowables().add(future.getError());
                continue;
            }
            ExitStatus status = future.getResult();
            result = result && this.canContinue(status);
            this.executeAfterInterceptors(future.getContext(), status);
        }
        Assert.state((boolean)queue.isEmpty(), (String)"Future results queue should be empty at end of batch.");
        return result;
    }

    protected RepeatInternalState createInternalState(RepeatContext context) {
        return new ResultQueueFactory().getResultQueue(this.throttleLimit);
    }

    public void setThrottleLimit(int throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    private static class ExecutingRunnable
    implements Runnable,
    ResultHolder {
        private final RepeatCallback callback;
        private final RepeatContext context;
        private final ResultQueue queue;
        private volatile ExitStatus result;
        private volatile Throwable error;

        public ExecutingRunnable(RepeatCallback callback, RepeatContext context, ResultQueue queue) {
            this.callback = callback;
            this.context = context;
            this.queue = queue;
        }

        public void expect() {
            this.queue.expect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.result = this.callback.doInIteration(this.context);
            }
            catch (Exception e) {
                this.error = e;
            }
            finally {
                this.queue.put(this);
            }
        }

        public ExitStatus getResult() {
            return this.result;
        }

        public Throwable getError() {
            return this.error;
        }

        public RepeatContext getContext() {
            return this.context;
        }
    }
}

