/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.support.RepeatInternalState;
import org.springframework.batch.repeat.support.RepeatInternalStateSupport;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.ResultHolder;
import org.springframework.batch.repeat.support.ResultQueue;
import org.springframework.batch.repeat.support.ThrottleLimitResultQueue;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class TaskExecutorRepeatTemplate
extends RepeatTemplate {
    public static final int DEFAULT_THROTTLE_LIMIT = 4;
    private int throttleLimit = 4;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();

    public void setThrottleLimit(int throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor);
        this.taskExecutor = taskExecutor;
    }

    protected RepeatStatus getNextResult(RepeatContext context, RepeatCallback callback, RepeatInternalState state) throws Throwable {
        ExecutingRunnable runnable = null;
        ResultQueue<ResultHolder> queue = ((ResultQueueInternalState)state).getResultQueue();
        ActivityBarrier lock = ((ResultQueueInternalState)state).getLock();
        do {
            runnable = new ExecutingRunnable(callback, context, queue, lock);
            runnable.expect();
            this.taskExecutor.execute((Runnable)runnable);
            this.update(context);
        } while (queue.isEmpty() && !this.isComplete(context));
        ResultHolder result = queue.take();
        if (result.getError() != null) {
            throw result.getError();
        }
        return result.getResult();
    }

    protected boolean waitForResults(RepeatInternalState state) {
        ResultQueue<ResultHolder> queue = ((ResultQueueInternalState)state).getResultQueue();
        ActivityBarrier lock = ((ResultQueueInternalState)state).getLock();
        boolean result = true;
        while (queue.isExpecting()) {
            ResultHolder future;
            lock.release();
            try {
                future = queue.take();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RepeatException("InterruptedException while waiting for result.");
            }
            if (future.getError() != null) {
                state.getThrowables().add(future.getError());
                continue;
            }
            RepeatStatus status = future.getResult();
            result = result && this.canContinue(status);
            this.executeAfterInterceptors(future.getContext(), status);
        }
        Assert.state((boolean)queue.isEmpty(), (String)"Future results queue should be empty at end of batch.");
        return result;
    }

    protected RepeatInternalState createInternalState(RepeatContext context) {
        return new ResultQueueInternalState(this.throttleLimit);
    }

    private static class ActivityBarrier {
        private static Log logger = LogFactory.getLog(ActivityBarrier.class);
        private volatile int active = 0;
        private volatile boolean paused = false;
        private final Object lock = new Object();

        private ActivityBarrier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            Object object = this.lock;
            synchronized (object) {
                ++this.active;
                this.paused = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release(boolean complete, RepeatStatus result) {
            boolean stillActive = false;
            Object object = this.lock;
            synchronized (object) {
                --this.active;
                boolean bl = stillActive = this.active > 0 || this.paused;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Completed callback with result = " + (Object)((Object)result) + ", " + this.active + " active callbacks, and paused=" + this.paused));
                }
            }
            if (result == RepeatStatus.FINISHED) {
                if (stillActive) {
                    logger.debug((Object)"Waiting for other active callbacks to finish.");
                    object = this.lock;
                    synchronized (object) {
                        while (true) {
                            if (!stillActive) {
                                return;
                            }
                            try {
                                this.lock.wait(2000L);
                                if (this.active <= 0 && !this.paused) {
                                    return;
                                }
                                boolean bl = true;
                                stillActive = bl;
                            }
                            catch (InterruptedException interruptedException) {
                                logger.info((Object)"Interrupted waiting for active callbacks");
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                }
                object = this.lock;
                synchronized (object) {
                    logger.debug((Object)"Notifying other waiting callbacks on finish.");
                    this.paused = false;
                    this.lock.notifyAll();
                    return;
                }
            }
            if (complete) {
                object = this.lock;
                synchronized (object) {
                    logger.debug((Object)"Notifying other waiting callbacks on policy based completion.");
                    this.paused = false;
                    this.lock.notifyAll();
                    return;
                }
            }
            object = this.lock;
            synchronized (object) {
                this.paused = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutingRunnable
    implements Runnable,
    ResultHolder {
        private final RepeatCallback callback;
        private final RepeatContext context;
        private final ResultQueue<ResultHolder> queue;
        private volatile RepeatStatus result;
        private volatile Throwable error;
        private final ActivityBarrier lock;

        public ExecutingRunnable(RepeatCallback callback, RepeatContext context, ResultQueue<ResultHolder> queue, ActivityBarrier lock) {
            this.callback = callback;
            this.context = context;
            this.queue = queue;
            this.lock = lock;
        }

        public void expect() {
            try {
                this.queue.expect();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RepeatException("InterruptedException waiting for to acquire lock on input.");
            }
        }

        @Override
        public void run() {
            boolean clearContext = false;
            try {
                try {
                    if (RepeatSynchronizationManager.getContext() == null) {
                        clearContext = true;
                        RepeatSynchronizationManager.register(this.context);
                    }
                    this.lock.acquire();
                    this.result = this.callback.doInIteration(this.context);
                }
                catch (Exception e) {
                    this.error = e;
                    this.lock.release(TaskExecutorRepeatTemplate.this.isComplete(this.context), this.result);
                    if (clearContext) {
                        RepeatSynchronizationManager.clear();
                    }
                    this.queue.put(this);
                }
            }
            finally {
                this.lock.release(TaskExecutorRepeatTemplate.this.isComplete(this.context), this.result);
                if (clearContext) {
                    RepeatSynchronizationManager.clear();
                }
                this.queue.put(this);
            }
        }

        @Override
        public RepeatStatus getResult() {
            return this.result;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public RepeatContext getContext() {
            return this.context;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultQueueInternalState
    extends RepeatInternalStateSupport {
        private final ResultQueue<ResultHolder> results;
        private final ActivityBarrier lock;

        public ResultQueueInternalState(int throttleLimit) {
            this.results = new ThrottleLimitResultQueue<ResultHolder>(throttleLimit);
            this.lock = new ActivityBarrier();
        }

        public ActivityBarrier getLock() {
            return this.lock;
        }

        public ResultQueue<ResultHolder> getResultQueue() {
            return this.results;
        }
    }
}

