/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.context.RetryContextSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRetryPolicy
implements RetryPolicy {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private volatile int maxAttempts;
    private BinaryExceptionClassifier retryableClassifier = new BinaryExceptionClassifier();
    private BinaryExceptionClassifier fatalClassifier = new BinaryExceptionClassifier();

    public SimpleRetryPolicy() {
        this(3);
    }

    public SimpleRetryPolicy(int maxAttempts) {
        HashSet<Class<Throwable>> classes = new HashSet<Class<? extends Throwable>>();
        classes.add(Exception.class);
        this.setRetryableExceptionClasses(classes);
        classes = new HashSet();
        this.setFatalExceptionClasses(classes);
        this.maxAttempts = maxAttempts;
    }

    public void setMaxAttempts(int retryAttempts) {
        this.maxAttempts = retryAttempts;
    }

    @Override
    public boolean canRetry(RetryContext context) {
        Exception t = context.getLastThrowable();
        return (t == null || this.retryForException(t)) && context.getRetryCount() < this.maxAttempts;
    }

    public final void setRetryableExceptionClasses(Collection<Class<? extends Throwable>> retryableExceptionClasses) {
        this.retryableClassifier.setTypes(retryableExceptionClasses);
    }

    public final void setFatalExceptionClasses(Collection<Class<? extends Throwable>> fatalExceptionClasses) {
        this.fatalClassifier.setTypes(fatalExceptionClasses);
    }

    @Override
    public void close(RetryContext status) {
    }

    @Override
    public void registerThrowable(RetryContext context, Exception throwable) {
        SimpleRetryContext simpleContext = (SimpleRetryContext)context;
        simpleContext.registerThrowable(throwable);
    }

    @Override
    public RetryContext open(RetryContext parent) {
        return new SimpleRetryContext(parent);
    }

    private boolean retryForException(Throwable ex) {
        return (Boolean)this.fatalClassifier.classify(ex) == false && (Boolean)this.retryableClassifier.classify(ex) != false;
    }

    private static class SimpleRetryContext
    extends RetryContextSupport {
        public SimpleRetryContext(RetryContext parent) {
            super(parent);
        }
    }
}

