/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesItemReader
extends ExecutionContextUserSupport
implements ItemStreamReader<Resource> {
    private Resource[] resources = new Resource[0];
    private AtomicInteger counter = new AtomicInteger(0);

    public ResourcesItemReader() {
        this.setName(this.getClass().getName());
    }

    public void setResources(Resource[] resources) {
        this.resources = Arrays.asList(resources).toArray(new Resource[resources.length]);
    }

    @Override
    public synchronized Resource read() throws Exception {
        int index = this.counter.incrementAndGet() - 1;
        if (index >= this.resources.length) {
            return null;
        }
        return this.resources[index];
    }

    @Override
    public void close() throws ItemStreamException {
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.counter.set(executionContext.getInt(this.getKey("COUNT"), 0));
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        executionContext.putInt(this.getKey("COUNT"), this.counter.get());
    }
}

