/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.List;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CompositeItemProcessor<I, O>
implements ItemProcessor<I, O>,
InitializingBean {
    private List<ItemProcessor<Object, Object>> delegates;

    @Override
    public O process(I item) throws Exception {
        Object result = item;
        for (ItemProcessor<Object, Object> delegate : this.delegates) {
            if (result == null) {
                return null;
            }
            result = delegate.process(result);
        }
        return (O)result;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegates, (String)"The 'delgates' may not be null");
        Assert.notEmpty(this.delegates, (String)"The 'delgates' may not be empty");
    }

    public void setDelegates(List<ItemProcessor<Object, Object>> delegates) {
        this.delegates = delegates;
    }
}

