/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.batch.item.file.transform.AbstractLineTokenizer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DelimitedLineTokenizer
extends AbstractLineTokenizer
implements InitializingBean {
    public static final String DELIMITER_TAB = "\t";
    public static final String DELIMITER_COMMA = ",";
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    private String delimiter;
    private char quoteCharacter = (char)34;
    private String quoteString;
    private String escapedQuoteString;
    private Collection<Integer> includedFields = null;

    public DelimitedLineTokenizer() {
        this(DELIMITER_COMMA);
    }

    public DelimitedLineTokenizer(String delimiter) {
        Assert.notNull((Object)delimiter, (String)"A delimiter is required");
        Assert.state((!delimiter.equals(String.valueOf('\"')) ? 1 : 0) != 0, (String)"[\"] is not allowed as delimiter for tokenizers.");
        this.delimiter = delimiter;
        this.setQuoteCharacter('\"');
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setIncludedFields(int ... includedFields) {
        this.includedFields = new HashSet<Integer>();
        for (int i : includedFields) {
            this.includedFields.add(i);
        }
    }

    public void setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
        this.quoteString = "" + quoteCharacter;
        this.escapedQuoteString = "" + quoteCharacter + quoteCharacter;
    }

    @Override
    protected List<String> doTokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean inQuoted = false;
        int lastCut = 0;
        int length = line.length();
        int fieldCount = 0;
        int endIndexLastDelimiter = -1;
        for (int i = 0; i < length; ++i) {
            char currentChar = line.charAt(i);
            boolean isEnd = i == length - 1;
            boolean isDelimiter = this.endsWithDelimiter(line, i, endIndexLastDelimiter);
            if (isDelimiter && !inQuoted || isEnd) {
                int endPosition;
                endIndexLastDelimiter = i;
                int n = endPosition = isEnd ? length - lastCut : i - lastCut;
                if (isEnd && isDelimiter) {
                    endPosition -= this.delimiter.length();
                } else if (!isEnd) {
                    endPosition = endPosition - this.delimiter.length() + 1;
                }
                if (this.includedFields == null || this.includedFields.contains(fieldCount)) {
                    String value = this.substringWithTrimmedWhitespaceAndQuotesIfQuotesPresent(line, lastCut, endPosition);
                    tokens.add(value);
                }
                ++fieldCount;
                if (isEnd && isDelimiter) {
                    if (this.includedFields == null || this.includedFields.contains(fieldCount)) {
                        tokens.add("");
                    }
                    ++fieldCount;
                }
                lastCut = i + 1;
                continue;
            }
            if (!this.isQuoteCharacter(currentChar)) continue;
            inQuoted = !inQuoted;
        }
        return tokens;
    }

    private String substringWithTrimmedWhitespaceAndQuotesIfQuotesPresent(String line, int offset, int count) {
        String value;
        int start = offset;
        int len = count;
        while (start < start + len - 1 && line.charAt(start) <= ' ') {
            ++start;
            --len;
        }
        while (start < start + len && start + len - 1 < line.length() && line.charAt(start + len - 1) <= ' ') {
            --len;
        }
        if (line.length() >= 2 && line.charAt(start) == this.quoteCharacter && line.charAt(start + len - 1) == this.quoteCharacter) {
            int beginIndex = start + 1;
            int endIndex = len - 2;
            value = line.substring(beginIndex, beginIndex + endIndex);
            if (value.contains(this.escapedQuoteString)) {
                value = StringUtils.replace((String)value, (String)this.escapedQuoteString, (String)this.quoteString);
            }
        } else {
            value = line.substring(offset, offset + count);
        }
        return value;
    }

    private boolean endsWithDelimiter(String line, int end, int previous) {
        boolean result = false;
        if (end - previous >= this.delimiter.length() && end >= this.delimiter.length() - 1) {
            result = true;
            for (int j = 0; j < this.delimiter.length() && end - this.delimiter.length() + 1 + j < line.length(); ++j) {
                if (this.delimiter.charAt(j) == line.charAt(end - this.delimiter.length() + 1 + j)) continue;
                result = false;
            }
        }
        return result;
    }

    protected boolean isQuoteCharacter(char c) {
        return c == this.quoteCharacter;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.delimiter, (String)"A delimiter is required");
    }
}

