/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.builder;

import java.util.Map;
import org.hibernate.SessionFactory;
import org.springframework.batch.item.database.HibernatePagingItemReader;
import org.springframework.batch.item.database.orm.HibernateQueryProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HibernatePagingItemReaderBuilder<T> {
    private int pageSize = 10;
    private Map<String, Object> parameterValues;
    private String queryName;
    private int fetchSize;
    private HibernateQueryProvider<? extends T> queryProvider;
    private String queryString;
    private SessionFactory sessionFactory;
    private boolean statelessSession = true;
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public HibernatePagingItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> queryProvider(HibernateQueryProvider<T> queryProvider) {
        this.queryProvider = queryProvider;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public HibernatePagingItemReaderBuilder<T> sessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        return this;
    }

    @Deprecated
    public HibernatePagingItemReaderBuilder<T> useSatelessSession(boolean useStatelessSession) {
        return this.useStatelessSession(useStatelessSession);
    }

    public HibernatePagingItemReaderBuilder<T> useStatelessSession(boolean useStatelessSession) {
        this.statelessSession = useStatelessSession;
        return this;
    }

    public HibernatePagingItemReader<T> build() {
        Assert.notNull((Object)this.sessionFactory, (String)"A SessionFactory must be provided");
        Assert.state((this.fetchSize >= 0 ? 1 : 0) != 0, (String)"fetchSize must not be negative");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        if (this.queryProvider == null) {
            Assert.state((boolean)(StringUtils.hasText((String)this.queryString) ^ StringUtils.hasText((String)this.queryName)), (String)"queryString or queryName must be set");
        }
        HibernatePagingItemReader<? extends T> reader = new HibernatePagingItemReader<T>();
        reader.setSessionFactory(this.sessionFactory);
        reader.setSaveState(this.saveState);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setName(this.name);
        reader.setFetchSize(this.fetchSize);
        reader.setParameterValues(this.parameterValues);
        reader.setQueryName(this.queryName);
        reader.setQueryProvider(this.queryProvider);
        reader.setQueryString(this.queryString);
        reader.setPageSize(this.pageSize);
        reader.setUseStatelessSession(this.statelessSession);
        return reader;
    }
}

