/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.exception;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.context.RepeatContextCounter;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.classify.Classifier;
import org.springframework.classify.SubclassClassifier;
import org.springframework.util.ObjectUtils;

public class RethrowOnThresholdExceptionHandler
implements ExceptionHandler {
    protected static final IntegerHolder ZERO = new IntegerHolder(0);
    protected final Log logger = LogFactory.getLog(RethrowOnThresholdExceptionHandler.class);
    private Classifier<? super Throwable, IntegerHolder> exceptionClassifier = (Classifier & Serializable)classifiable -> ZERO;
    private boolean useParent = false;

    public void setUseParent(boolean useParent) {
        this.useParent = useParent;
    }

    public void setThresholds(Map<Class<? extends Throwable>, Integer> thresholds) {
        HashMap<Class<? extends Throwable>, IntegerHolder> typeMap = new HashMap<Class<? extends Throwable>, IntegerHolder>();
        for (Map.Entry<Class<? extends Throwable>, Integer> entry : thresholds.entrySet()) {
            typeMap.put(entry.getKey(), new IntegerHolder(entry.getValue()));
        }
        this.exceptionClassifier = new SubclassClassifier(typeMap, (Object)ZERO);
    }

    @Override
    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        IntegerHolder key = (IntegerHolder)this.exceptionClassifier.classify((Object)throwable);
        RepeatContextCounter counter = this.getCounter(context, key);
        counter.increment();
        int count = counter.getCount();
        int threshold = key.getValue();
        if (count > threshold) {
            throw throwable;
        }
    }

    private RepeatContextCounter getCounter(RepeatContext context, IntegerHolder key) {
        String attribute = RethrowOnThresholdExceptionHandler.class.getName() + "." + key;
        return new RepeatContextCounter(context, attribute, this.useParent);
    }

    private static class IntegerHolder {
        private final int value;

        public IntegerHolder(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return ObjectUtils.getIdentityHexString((Object)this) + "." + this.value;
        }
    }
}

