/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.ldif.builder;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ldif.MappingLdifReader;
import org.springframework.batch.infrastructure.item.ldif.RecordCallbackHandler;
import org.springframework.batch.infrastructure.item.ldif.RecordMapper;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class MappingLdifReaderBuilder<T> {
    private @Nullable Resource resource;
    private int recordsToSkip = 0;
    private boolean strict = true;
    private @Nullable RecordCallbackHandler skippedRecordsCallback;
    private @Nullable RecordMapper<T> recordMapper;
    private boolean saveState = true;
    private @Nullable String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public MappingLdifReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MappingLdifReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public MappingLdifReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MappingLdifReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public MappingLdifReaderBuilder<T> strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public MappingLdifReaderBuilder<T> skippedRecordsCallback(RecordCallbackHandler skippedRecordsCallback) {
        this.skippedRecordsCallback = skippedRecordsCallback;
        return this;
    }

    public MappingLdifReaderBuilder<T> recordsToSkip(int recordsToSkip) {
        this.recordsToSkip = recordsToSkip;
        return this;
    }

    public MappingLdifReaderBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public MappingLdifReaderBuilder<T> recordMapper(RecordMapper<T> recordMapper) {
        this.recordMapper = recordMapper;
        return this;
    }

    public MappingLdifReader<T> build() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Resource is required.");
        Assert.notNull(this.recordMapper, (String)"RecordMapper is required.");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        MappingLdifReader<T> reader = new MappingLdifReader<T>(this.resource);
        reader.setRecordsToSkip(this.recordsToSkip);
        reader.setSaveState(this.saveState);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setRecordMapper(this.recordMapper);
        if (this.name != null) {
            reader.setName(this.name);
        }
        if (this.skippedRecordsCallback != null) {
            reader.setSkippedRecordsCallback(this.skippedRecordsCallback);
        }
        reader.setStrict(this.strict);
        reader.afterPropertiesSet();
        return reader;
    }
}

