/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.redis;

import org.springframework.batch.infrastructure.item.KeyValueItemWriter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisItemWriter<K, T>
extends KeyValueItemWriter<K, T> {
    private RedisTemplate<K, T> redisTemplate;

    public RedisItemWriter(Converter<T, K> itemKeyMapper, RedisTemplate<K, T> redisTemplate) {
        super(itemKeyMapper);
        Assert.notNull(redisTemplate, (String)"RedisTemplate must not be null");
        this.redisTemplate = redisTemplate;
    }

    @Override
    protected void writeKeyValue(K key, T value) {
        if (this.delete) {
            this.redisTemplate.delete(key);
        } else {
            this.redisTemplate.opsForValue().set(key, value);
        }
    }

    @Override
    protected void init() {
        Assert.notNull(this.redisTemplate, (String)"RedisTemplate must not be null");
    }

    public void setRedisTemplate(RedisTemplate<K, T> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

