/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;

public class ExecutionContext
implements Serializable {
    private volatile boolean dirty = false;
    private final Map<String, Object> map;

    public ExecutionContext() {
        this.map = new ConcurrentHashMap<String, Object>();
    }

    public ExecutionContext(Map<String, Object> map) {
        this.map = new ConcurrentHashMap<String, Object>(map);
    }

    public ExecutionContext(ExecutionContext executionContext) {
        this();
        if (executionContext == null) {
            return;
        }
        this.map.putAll(executionContext.toMap());
    }

    public void putString(String key, @Nullable String value) {
        this.put(key, value);
    }

    public void putLong(String key, long value) {
        this.put(key, value);
    }

    public void putInt(String key, int value) {
        this.put(key, value);
    }

    public void putDouble(String key, double value) {
        this.put(key, value);
    }

    public void put(String key, @Nullable Object value) {
        if (value != null) {
            Object result = this.map.put(key, value);
            this.dirty = this.dirty || result == null || !result.equals(value);
        } else {
            Object result = this.map.remove(key);
            this.dirty = this.dirty || result != null;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getString(String key) {
        return this.readAndValidate(key, String.class);
    }

    public String getString(String key, String defaultString) {
        if (!this.containsKey(key)) {
            return defaultString;
        }
        return this.getString(key);
    }

    public long getLong(String key) {
        return this.readAndValidate(key, Long.class);
    }

    public long getLong(String key, long defaultLong) {
        if (!this.containsKey(key)) {
            return defaultLong;
        }
        return this.getLong(key);
    }

    public int getInt(String key) {
        return this.readAndValidate(key, Integer.class);
    }

    public int getInt(String key, int defaultInt) {
        if (!this.containsKey(key)) {
            return defaultInt;
        }
        return this.getInt(key);
    }

    public double getDouble(String key) {
        return this.readAndValidate(key, Double.class);
    }

    public double getDouble(String key, double defaultDouble) {
        if (!this.containsKey(key)) {
            return defaultDouble;
        }
        return this.getDouble(key);
    }

    public @Nullable Object get(String key) {
        return this.map.get(key);
    }

    public <V> @Nullable V get(String key, Class<V> type) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        return this.get(key, type, null);
    }

    public <V> @Nullable V get(String key, Class<V> type, @Nullable V defaultValue) {
        Object value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (!type.isInstance(value)) {
            throw new ClassCastException("Value for key=[" + key + "] is not of type: [" + String.valueOf(type) + "], it is [(" + String.valueOf(value.getClass()) + ")" + String.valueOf(value) + "]");
        }
        return type.cast(value);
    }

    private <V> V readAndValidate(String key, Class<V> type) {
        Object value = this.get(key);
        if (!type.isInstance(value)) {
            throw new ClassCastException("Value for key=[" + key + "] is not of type: [" + String.valueOf(type) + "], it is [" + (value == null ? null : "(" + String.valueOf(value.getClass()) + ")" + String.valueOf(value)) + "]");
        }
        return type.cast(value);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public @Nullable Object remove(String key) {
        return this.map.remove(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExecutionContext)) {
            return false;
        }
        ExecutionContext rhs = (ExecutionContext)obj;
        if (this == obj) {
            return true;
        }
        return this.entrySet().equals(rhs.entrySet());
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public int size() {
        return this.map.size();
    }
}

