/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointEnablement;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointEnablementProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.DefaultEnablement;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxEndpointExtension;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointExtension;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class OnEnabledEndpointCondition
extends SpringBootCondition {
    OnEnabledEndpointCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        EndpointAttributes attributes = this.getEndpointAttributes(context, metadata);
        EndpointEnablement endpointEnablement = attributes.getEnablement(new EndpointEnablementProvider(context.getEnvironment()));
        return new ConditionOutcome(endpointEnablement.isEnabled(), ConditionMessage.forCondition(ConditionalOnEnabledEndpoint.class, (Object[])new Object[0]).because(endpointEnablement.getReason()));
    }

    private EndpointAttributes getEndpointAttributes(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Assert.state((metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName()) ? 1 : 0) != 0, (String)"OnEnabledEndpointCondition may only be used on @Bean methods");
        return this.getEndpointAttributes(context, (MethodMetadata)metadata);
    }

    private EndpointAttributes getEndpointAttributes(ConditionContext context, MethodMetadata methodMetadata) {
        try {
            Class returnType = ClassUtils.forName((String)methodMetadata.getReturnTypeName(), (ClassLoader)context.getClassLoader());
            return this.extractEndpointAttributes(returnType);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to extract endpoint id for " + methodMetadata.getDeclaringClassName() + "." + methodMetadata.getMethodName(), ex);
        }
    }

    protected EndpointAttributes extractEndpointAttributes(Class<?> type) {
        EndpointAttributes attributes = this.extractEndpointAttributesFromEndpoint(type);
        if (attributes != null) {
            return attributes;
        }
        JmxEndpointExtension jmxExtension = (JmxEndpointExtension)AnnotationUtils.findAnnotation(type, JmxEndpointExtension.class);
        if (jmxExtension != null) {
            return this.extractEndpointAttributes(jmxExtension.endpoint());
        }
        WebEndpointExtension webExtension = (WebEndpointExtension)AnnotationUtils.findAnnotation(type, WebEndpointExtension.class);
        if (webExtension != null) {
            return this.extractEndpointAttributes(webExtension.endpoint());
        }
        throw new IllegalStateException("OnEnabledEndpointCondition may only be used on @Bean methods that return @Endpoint, @JmxEndpointExtension, or @WebEndpointExtension");
    }

    private EndpointAttributes extractEndpointAttributesFromEndpoint(Class<?> endpointClass) {
        Endpoint endpoint = (Endpoint)AnnotationUtils.findAnnotation(endpointClass, Endpoint.class);
        if (endpoint == null) {
            return null;
        }
        EndpointExposure[] exposures = endpoint.exposure();
        return new EndpointAttributes(endpoint.id(), endpoint.defaultEnablement(), exposures.length == 1 ? exposures[0] : null);
    }

    private static class EndpointAttributes {
        private final String id;
        private final DefaultEnablement defaultEnablement;
        private final EndpointExposure exposure;

        EndpointAttributes(String id, DefaultEnablement defaultEnablement, EndpointExposure exposure) {
            if (!StringUtils.hasText((String)id)) {
                throw new IllegalStateException("Endpoint id could not be determined");
            }
            this.id = id;
            this.defaultEnablement = defaultEnablement;
            this.exposure = exposure;
        }

        public EndpointEnablement getEnablement(EndpointEnablementProvider provider) {
            return provider.getEndpointEnablement(this.id, this.defaultEnablement, this.exposure);
        }
    }
}

