/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import java.util.Properties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="management.endpoints.jmx")
public class JmxEndpointExporterProperties {
    private String domain = "org.springframework.boot";
    private boolean uniqueNames = false;
    private final Properties staticNames = new Properties();

    public JmxEndpointExporterProperties(Environment environment) {
        String defaultDomain = environment.getProperty("spring.jmx.default-domain");
        if (StringUtils.hasText((String)defaultDomain)) {
            this.domain = defaultDomain;
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isUniqueNames() {
        return this.uniqueNames;
    }

    public void setUniqueNames(boolean uniqueNames) {
        this.uniqueNames = uniqueNames;
    }

    public Properties getStaticNames() {
        return this.staticNames;
    }
}

