/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.health.CompositeReactiveHealthIndicatorFactory;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthReactiveWebEndpointExtension;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.HealthWebEndpointExtension;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.StatusEndpoint;
import org.springframework.boot.actuate.health.StatusReactiveWebEndpointExtension;
import org.springframework.boot.actuate.health.StatusWebEndpointExtension;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ManagementContextConfiguration
@EnableConfigurationProperties(value={HealthIndicatorProperties.class})
public class HealthWebEndpointManagementContextConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HealthStatusHttpMapper createHealthStatusHttpMapper(HealthIndicatorProperties healthIndicatorProperties) {
        HealthStatusHttpMapper statusHttpMapper = new HealthStatusHttpMapper();
        if (healthIndicatorProperties.getHttpMapping() != null) {
            statusHttpMapper.addStatusMapping(healthIndicatorProperties.getHttpMapping());
        }
        return statusHttpMapper;
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class ServletWebHealthConfiguration {
        ServletWebHealthConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint
        @ConditionalOnBean(value={HealthEndpoint.class})
        public HealthWebEndpointExtension healthWebEndpointExtension(HealthEndpoint delegate, HealthStatusHttpMapper healthStatusHttpMapper) {
            return new HealthWebEndpointExtension(delegate, healthStatusHttpMapper);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint
        @ConditionalOnBean(value={StatusEndpoint.class})
        public StatusWebEndpointExtension statusWebEndpointExtension(StatusEndpoint delegate, HealthStatusHttpMapper healthStatusHttpMapper) {
            return new StatusWebEndpointExtension(delegate, healthStatusHttpMapper);
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class ReactiveWebHealthConfiguration {
        private final ReactiveHealthIndicator reactiveHealthIndicator;

        ReactiveWebHealthConfiguration(ObjectProvider<HealthAggregator> healthAggregator, ObjectProvider<Map<String, ReactiveHealthIndicator>> reactiveHealthIndicators, ObjectProvider<Map<String, HealthIndicator>> healthIndicators) {
            this.reactiveHealthIndicator = new CompositeReactiveHealthIndicatorFactory().createReactiveHealthIndicator((HealthAggregator)healthAggregator.getIfAvailable(OrderedHealthAggregator::new), (Map)reactiveHealthIndicators.getIfAvailable(Collections::emptyMap), (Map)healthIndicators.getIfAvailable(Collections::emptyMap));
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint
        @ConditionalOnBean(value={HealthEndpoint.class})
        public HealthReactiveWebEndpointExtension healthWebEndpointExtension(HealthStatusHttpMapper healthStatusHttpMapper) {
            return new HealthReactiveWebEndpointExtension(this.reactiveHealthIndicator, healthStatusHttpMapper);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint
        @ConditionalOnBean(value={StatusEndpoint.class})
        public StatusReactiveWebEndpointExtension statusWebEndpointExtension(HealthStatusHttpMapper healthStatusHttpMapper) {
            return new StatusReactiveWebEndpointExtension(this.reactiveHealthIndicator, healthStatusHttpMapper);
        }
    }
}

