/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.logging;

import org.springframework.boot.actuate.autoconfigure.logging.LogFileWebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.logging.LogFileWebEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

@ManagementContextConfiguration
@EnableConfigurationProperties(value={LogFileWebEndpointProperties.class})
public class LogFileWebEndpointManagementContextConfiguration {
    private final LogFileWebEndpointProperties properties;

    public LogFileWebEndpointManagementContextConfiguration(LogFileWebEndpointProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={LogFileCondition.class})
    public LogFileWebEndpoint logFileWebEndpoint(Environment environment) {
        return new LogFileWebEndpoint(environment, this.properties.getExternalFile());
    }

    private static class LogFileCondition
    extends SpringBootCondition {
        private LogFileCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            String config = environment.resolvePlaceholders("${logging.file:}");
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Log File", (Object[])new Object[0]);
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((ConditionMessage)message.found("logging.file").items(new Object[]{config}));
            }
            config = environment.resolvePlaceholders("${logging.path:}");
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((ConditionMessage)message.found("logging.path").items(new Object[]{config}));
            }
            config = environment.getProperty("endpoints.logfile.external-file");
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((ConditionMessage)message.found("endpoints.logfile.external-file").items(new Object[]{config}));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("logging file").atAll());
        }
    }
}

