/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class MeterBindersConfiguration {
    MeterBindersConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={JvmMemoryMetrics.class})
    public JvmMemoryMetrics jvmMemoryMetrics() {
        return new JvmMemoryMetrics();
    }

    @Bean
    @ConditionalOnMissingBean(value={LogbackMetrics.class})
    @ConditionalOnClass(name={"ch.qos.logback.classic.Logger"})
    public LogbackMetrics logbackMetrics() {
        return new LogbackMetrics();
    }

    @Bean
    @ConditionalOnMissingBean(value={UptimeMetrics.class})
    public UptimeMetrics uptimeMetrics() {
        return new UptimeMetrics();
    }
}

