/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.influx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.export.MetricsExporter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.StringToDurationConverter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.influx.InfluxProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.influx.InfluxPropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={InfluxMeterRegistry.class})
@Import(value={StringToDurationConverter.class})
@EnableConfigurationProperties(value={InfluxProperties.class})
public class InfluxExportConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={InfluxConfig.class})
    public InfluxConfig influxConfig(InfluxProperties influxProperties) {
        return new InfluxPropertiesConfigAdapter(influxProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.influx.enabled"}, matchIfMissing=true)
    public MetricsExporter influxExporter(InfluxConfig influxConfig, Clock clock) {
        return () -> new InfluxMeterRegistry(influxConfig, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }
}

