/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.EndpointPathProvider;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.security.ApplicationContextRequestMatcher;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class EndpointRequest {
    private EndpointRequest() {
    }

    public static EndpointRequestMatcher toAnyEndpoint() {
        return new EndpointRequestMatcher();
    }

    public static EndpointRequestMatcher to(Class<?> ... endpoints) {
        return new EndpointRequestMatcher(endpoints);
    }

    public static EndpointRequestMatcher to(String ... endpoints) {
        return new EndpointRequestMatcher(endpoints);
    }

    public static final class EndpointRequestMatcher
    extends ApplicationContextRequestMatcher<EndpointPathProvider> {
        private final List<Object> includes;
        private final List<Object> excludes;
        private RequestMatcher delegate;

        private EndpointRequestMatcher() {
            super(EndpointPathProvider.class);
            this.includes = Collections.emptyList();
            this.excludes = Collections.emptyList();
        }

        private EndpointRequestMatcher(Class<?>[] endpoints) {
            super(EndpointPathProvider.class);
            this.includes = Arrays.asList((Object[])endpoints);
            this.excludes = Collections.emptyList();
        }

        private EndpointRequestMatcher(String[] endpoints) {
            super(EndpointPathProvider.class);
            this.includes = Arrays.asList((Object[])endpoints);
            this.excludes = Collections.emptyList();
        }

        private EndpointRequestMatcher(List<Object> includes, List<Object> excludes) {
            super(EndpointPathProvider.class);
            this.includes = includes;
            this.excludes = excludes;
        }

        EndpointRequestMatcher excluding(Class<?> ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes);
        }

        EndpointRequestMatcher excluding(String ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes);
        }

        protected void initialized(EndpointPathProvider endpointPathProvider) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>(this.includes.isEmpty() ? endpointPathProvider.getPaths() : Collections.emptyList());
            this.streamPaths(this.includes, endpointPathProvider).forEach(paths::add);
            this.streamPaths(this.excludes, endpointPathProvider).forEach(paths::remove);
            this.delegate = new OrRequestMatcher(this.getDelegateMatchers(paths));
        }

        private Stream<String> streamPaths(List<Object> source, EndpointPathProvider endpointPathProvider) {
            return source.stream().filter(Objects::nonNull).map(this::getPathId).map(endpointPathProvider::getPath);
        }

        private String getPathId(Object source) {
            if (source instanceof String) {
                return (String)source;
            }
            if (source instanceof Class) {
                return this.getPathId((Class)source);
            }
            throw new IllegalStateException("Unsupported source " + source);
        }

        private String getPathId(Class<?> source) {
            Endpoint annotation = (Endpoint)AnnotationUtils.findAnnotation(source, Endpoint.class);
            Assert.state((annotation != null ? 1 : 0) != 0, (String)("Class " + source + " is not annotated with @Endpoint"));
            return annotation.id();
        }

        private List<RequestMatcher> getDelegateMatchers(Set<String> paths) {
            return paths.stream().map(path -> new AntPathRequestMatcher(path + "/**")).collect(Collectors.toList());
        }

        public boolean matches(HttpServletRequest request) {
            try {
                return super.matches(request);
            }
            catch (BeanCreationException ex) {
                return false;
            }
        }

        protected boolean matches(HttpServletRequest request, EndpointPathProvider context) {
            return this.delegate.matches(request);
        }
    }
}

