/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableChildManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableManagementContext;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.reactive.context.ConfigurableReactiveWebApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.Assert;
import org.springframework.web.context.ConfigurableWebApplicationContext;

@Configuration
@AutoConfigureOrder(value=0x7FFFFFFF)
@EnableConfigurationProperties(value={ManagementServerProperties.class})
public class ManagementContextAutoConfiguration {

    private static class CloseManagementContextListener
    implements ApplicationListener<ApplicationEvent> {
        private final ApplicationContext parentContext;
        private final ConfigurableApplicationContext childContext;

        CloseManagementContextListener(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            this.parentContext = parentContext;
            this.childContext = childContext;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof ContextClosedEvent) {
                this.onContextClosedEvent((ContextClosedEvent)event);
            }
            if (event instanceof ApplicationFailedEvent) {
                this.onApplicationFailedEvent((ApplicationFailedEvent)event);
            }
        }

        private void onContextClosedEvent(ContextClosedEvent event) {
            this.propagateCloseIfNecessary(event.getApplicationContext());
        }

        private void onApplicationFailedEvent(ApplicationFailedEvent event) {
            this.propagateCloseIfNecessary((ApplicationContext)event.getApplicationContext());
        }

        private void propagateCloseIfNecessary(ApplicationContext applicationContext) {
            if (applicationContext == this.parentContext) {
                this.childContext.close();
            }
        }

        public static void addIfPossible(ApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            if (parentContext instanceof ConfigurableApplicationContext) {
                CloseManagementContextListener.add((ConfigurableApplicationContext)parentContext, childContext);
            }
        }

        private static void add(ConfigurableApplicationContext parentContext, ConfigurableApplicationContext childContext) {
            parentContext.addApplicationListener((ApplicationListener)new CloseManagementContextListener((ApplicationContext)parentContext, childContext));
        }
    }

    @Configuration
    @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
    static class DifferentManagementContextConfiguration
    implements SmartInitializingSingleton {
        private final ApplicationContext applicationContext;
        private final ManagementContextFactory managementContextFactory;

        DifferentManagementContextConfiguration(ApplicationContext applicationContext, ManagementContextFactory managementContextFactory) {
            this.applicationContext = applicationContext;
            this.managementContextFactory = managementContextFactory;
        }

        public void afterSingletonsInstantiated() {
            ConfigurableApplicationContext managementContext = this.managementContextFactory.createManagementContext(this.applicationContext, EnableChildManagementContextConfiguration.class, PropertyPlaceholderAutoConfiguration.class);
            this.setNamespaceIfPossible(managementContext);
            managementContext.setId(this.applicationContext.getId() + ":management");
            this.setClassLoaderIfPossible(managementContext);
            CloseManagementContextListener.addIfPossible(this.applicationContext, managementContext);
            managementContext.refresh();
        }

        private void setClassLoaderIfPossible(ConfigurableApplicationContext child) {
            if (child instanceof DefaultResourceLoader) {
                ((AbstractApplicationContext)child).setClassLoader(this.applicationContext.getClassLoader());
            }
        }

        private void setNamespaceIfPossible(ConfigurableApplicationContext child) {
            if (child instanceof ConfigurableReactiveWebApplicationContext) {
                ((ConfigurableReactiveWebApplicationContext)child).setNamespace("management");
            } else if (child instanceof ConfigurableWebApplicationContext) {
                ((ConfigurableWebApplicationContext)child).setNamespace("management");
            }
        }
    }

    @Configuration
    @ConditionalOnManagementPort(value=ManagementPortType.SAME)
    static class SameManagementContextConfiguration
    implements SmartInitializingSingleton {
        private final Environment environment;

        SameManagementContextConfiguration(Environment environment) {
            this.environment = environment;
        }

        public void afterSingletonsInstantiated() {
            this.verifySslConfiguration();
            if (this.environment instanceof ConfigurableEnvironment) {
                this.addLocalManagementPortPropertyAlias((ConfigurableEnvironment)this.environment);
            }
        }

        private void verifySslConfiguration() {
            Boolean enabled = (Boolean)this.environment.getProperty("management.ssl.enabled", Boolean.class, (Object)false);
            Assert.state((enabled == false ? 1 : 0) != 0, (String)"Management-specific SSL cannot be configured as the management server is not listening on a separate port");
        }

        private void addLocalManagementPortPropertyAlias(final ConfigurableEnvironment environment) {
            environment.getPropertySources().addLast((PropertySource)new PropertySource<Object>("Management Server"){

                public Object getProperty(String name) {
                    if ("local.management.port".equals(name)) {
                        return environment.getProperty("local.server.port");
                    }
                    return null;
                }
            });
        }

        @EnableManagementContext(value=ManagementContextType.SAME)
        static class EnableSameManagementContextConfiguration {
            EnableSameManagementContextConfiguration() {
            }
        }
    }
}

