/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet;

import java.util.Arrays;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundrySecurityService;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryWebEndpointServletHandlerMapping;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.TokenValidator;
import org.springframework.boot.actuate.autoconfigure.endpoint.DefaultCachingConfigurationFactory;
import org.springframework.boot.actuate.autoconfigure.web.servlet.ServletManagementContextAutoConfiguration;
import org.springframework.boot.actuate.endpoint.ParameterMapper;
import org.springframework.boot.actuate.endpoint.cache.CachingConfigurationFactory;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.EndpointPathResolver;
import org.springframework.boot.actuate.endpoint.web.annotation.WebAnnotationEndpointDiscoverer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnProperty(prefix="management.cloudfoundry", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={ServletManagementContextAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnBean(value={DispatcherServlet.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
public class CloudFoundryActuatorAutoConfiguration {
    private final ApplicationContext applicationContext;

    CloudFoundryActuatorAutoConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Bean
    public CloudFoundryWebEndpointServletHandlerMapping cloudFoundryWebEndpointServletHandlerMapping(ParameterMapper parameterMapper, DefaultCachingConfigurationFactory cachingConfigurationFactory, EndpointMediaTypes endpointMediaTypes, Environment environment, RestTemplateBuilder builder) {
        WebAnnotationEndpointDiscoverer endpointDiscoverer = new WebAnnotationEndpointDiscoverer(this.applicationContext, parameterMapper, (CachingConfigurationFactory)cachingConfigurationFactory, endpointMediaTypes, EndpointPathResolver.useEndpointId());
        return new CloudFoundryWebEndpointServletHandlerMapping(new EndpointMapping("/cloudfoundryapplication"), endpointDiscoverer.discoverEndpoints(), endpointMediaTypes, this.getCorsConfiguration(), this.getSecurityInterceptor(builder, environment));
    }

    private CloudFoundrySecurityInterceptor getSecurityInterceptor(RestTemplateBuilder restTemplateBuilder, Environment environment) {
        CloudFoundrySecurityService cloudfoundrySecurityService = this.getCloudFoundrySecurityService(restTemplateBuilder, environment);
        TokenValidator tokenValidator = new TokenValidator(cloudfoundrySecurityService);
        return new CloudFoundrySecurityInterceptor(tokenValidator, cloudfoundrySecurityService, environment.getProperty("vcap.application.application_id"));
    }

    private CloudFoundrySecurityService getCloudFoundrySecurityService(RestTemplateBuilder restTemplateBuilder, Environment environment) {
        String cloudControllerUrl = environment.getProperty("vcap.application.cf_api");
        boolean skipSslValidation = (Boolean)environment.getProperty("management.cloudfoundry.skip-ssl-validation", Boolean.class, (Object)false);
        return cloudControllerUrl == null ? null : new CloudFoundrySecurityService(restTemplateBuilder, cloudControllerUrl, skipSslValidation);
    }

    private CorsConfiguration getCorsConfiguration() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.setAllowedMethods(Arrays.asList(HttpMethod.GET.name(), HttpMethod.POST.name()));
        corsConfiguration.setAllowedHeaders(Arrays.asList("Authorization", "X-Cf-App-Instance", "Content-Type"));
        return corsConfiguration;
    }

    @ConditionalOnClass(value={WebSecurity.class})
    @Order(value=-2147483648)
    @Configuration
    public static class IgnoredPathsWebSecurityConfigurer
    implements WebSecurityConfigurer<WebSecurity> {
        public void init(WebSecurity builder) throws Exception {
            builder.ignoring().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/cloudfoundryapplication/**")});
        }

        public void configure(WebSecurity builder) throws Exception {
        }
    }
}

