/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointEnablement;
import org.springframework.boot.actuate.endpoint.DefaultEnablement;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class EndpointEnablementProvider {
    private final Environment environment;

    public EndpointEnablementProvider(Environment environment) {
        this.environment = environment;
    }

    public EndpointEnablement getEndpointEnablement(String endpointId, DefaultEnablement defaultEnablement) {
        return this.getEndpointEnablement(endpointId, defaultEnablement, null);
    }

    public EndpointEnablement getEndpointEnablement(String endpointId, DefaultEnablement defaultEnablement, EndpointExposure exposure) {
        Assert.hasText((String)endpointId, (String)"Endpoint id must have a value");
        Assert.isTrue((!endpointId.equals("default") ? 1 : 0) != 0, (String)"Endpoint id 'default' is a reserved value and cannot be used by an endpoint");
        EndpointEnablement result = this.findEnablement(endpointId, exposure);
        if (result != null) {
            return result;
        }
        result = this.findEnablement(this.getKey(endpointId, "enabled"));
        if (result != null) {
            return result;
        }
        if (defaultEnablement != DefaultEnablement.NEUTRAL) {
            return this.getDefaultEndpointEnablement(endpointId, defaultEnablement == DefaultEnablement.ENABLED, exposure);
        }
        return this.getGlobalEndpointEnablement(endpointId, defaultEnablement, exposure);
    }

    private EndpointEnablement findEnablement(String endpointId, EndpointExposure exposure) {
        if (exposure != null) {
            return this.findEnablement(this.getKey(endpointId, exposure));
        }
        return this.findEnablementForAnyExposureTechnology(endpointId);
    }

    private EndpointEnablement getGlobalEndpointEnablement(String endpointId, DefaultEnablement defaultEnablement, EndpointExposure exposure) {
        EndpointEnablement result = this.findGlobalEndpointEnablement(exposure);
        if (result != null) {
            return result;
        }
        result = this.findEnablement(this.getKey("default", "enabled"));
        if (result != null) {
            return result;
        }
        boolean enablement = this.determineGlobalDefaultEnablement(defaultEnablement, exposure);
        String message = this.determineGlobalDefaultMessage(endpointId, enablement, exposure, defaultEnablement);
        return new EndpointEnablement(enablement, message);
    }

    private boolean determineGlobalDefaultEnablement(DefaultEnablement defaultEnablement, EndpointExposure exposure) {
        if (defaultEnablement == DefaultEnablement.NEUTRAL) {
            return exposure == null || exposure.isEnabledByDefault();
        }
        return defaultEnablement == DefaultEnablement.ENABLED;
    }

    private String determineGlobalDefaultMessage(String endpointId, boolean enablement, EndpointExposure exposure, DefaultEnablement defaultEnablement) {
        StringBuilder message = new StringBuilder();
        message.append(String.format("endpoint '%s' ", endpointId));
        if (exposure != null) {
            message.append(String.format("(%s) ", exposure.name().toLowerCase()));
        }
        message.append(String.format("is %s ", enablement ? "enabled" : "disabled"));
        if (defaultEnablement == DefaultEnablement.NEUTRAL) {
            if (exposure != null) {
                message.append(String.format("(default for %s endpoints)", exposure.name().toLowerCase()));
            } else {
                message.append("(default)");
            }
        } else {
            message.append("by default");
        }
        return message.toString();
    }

    private EndpointEnablement findGlobalEndpointEnablement(EndpointExposure exposure) {
        if (exposure != null) {
            EndpointEnablement result = this.findEnablement(this.getKey("default", exposure));
            if (result != null) {
                return result;
            }
            if (!exposure.isEnabledByDefault()) {
                return this.getDefaultEndpointEnablement("default", false, exposure);
            }
            return null;
        }
        return this.findEnablementForAnyExposureTechnology("default");
    }

    private EndpointEnablement findEnablementForAnyExposureTechnology(String endpointId) {
        for (EndpointExposure candidate : EndpointExposure.values()) {
            EndpointEnablement result = this.findEnablementForExposureTechnology(endpointId, candidate);
            if (result == null || !result.isEnabled()) continue;
            return result;
        }
        return null;
    }

    private EndpointEnablement findEnablementForExposureTechnology(String endpointId, EndpointExposure exposure) {
        String endpointTypeKey = this.getKey(endpointId, exposure);
        return this.findEnablement(endpointTypeKey);
    }

    private EndpointEnablement getDefaultEndpointEnablement(String endpointId, boolean enabledByDefault, EndpointExposure exposure) {
        return new EndpointEnablement(enabledByDefault, this.createDefaultEnablementMessage(endpointId, enabledByDefault, exposure));
    }

    private String createDefaultEnablementMessage(String endpointId, boolean enabledByDefault, EndpointExposure exposure) {
        StringBuilder message = new StringBuilder();
        message.append(String.format("endpoint '%s' ", endpointId));
        if (exposure != null) {
            message.append(String.format("(%s) ", exposure.name().toLowerCase()));
        }
        message.append(String.format("is %s by default", enabledByDefault ? "enabled" : "disabled"));
        return message.toString();
    }

    private String getKey(String endpointId, EndpointExposure exposure) {
        return this.getKey(endpointId, exposure.name().toLowerCase() + ".enabled");
    }

    private String getKey(String endpointId, String suffix) {
        return "endpoints." + endpointId + "." + suffix;
    }

    private EndpointEnablement findEnablement(String key) {
        if (this.environment.containsProperty(key)) {
            boolean match = (Boolean)this.environment.getProperty(key, Boolean.class, (Object)true);
            return new EndpointEnablement(match, String.format("found property %s", key));
        }
        return null;
    }
}

