/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.management.MBeanServer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.DefaultCachingConfigurationFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.DefaultEndpointObjectNameFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointExporter;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointExporterProperties;
import org.springframework.boot.actuate.endpoint.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.ParameterMapper;
import org.springframework.boot.actuate.endpoint.cache.CachingConfigurationFactory;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBeanRegistrar;
import org.springframework.boot.actuate.endpoint.jmx.EndpointObjectNameFactory;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperation;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxAnnotationEndpointDiscoverer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ObjectUtils;

@AutoConfigureAfter(value={JmxAutoConfiguration.class})
@EnableConfigurationProperties(value={JmxEndpointExporterProperties.class})
public class JmxEndpointAutoConfiguration {
    private final ApplicationContext applicationContext;

    public JmxEndpointAutoConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Bean
    public JmxAnnotationEndpointDiscoverer jmxEndpointDiscoverer(ParameterMapper parameterMapper, DefaultCachingConfigurationFactory cachingConfigurationFactory) {
        return new JmxAnnotationEndpointDiscoverer(this.applicationContext, parameterMapper, (CachingConfigurationFactory)cachingConfigurationFactory);
    }

    @ConditionalOnSingleCandidate(value=MBeanServer.class)
    @Bean
    public JmxEndpointExporter jmxMBeanExporter(JmxEndpointExporterProperties properties, MBeanServer mBeanServer, JmxAnnotationEndpointDiscoverer endpointDiscoverer, ObjectProvider<ObjectMapper> objectMapper) {
        EndpointProvider<JmxEndpointOperation> endpointProvider = new EndpointProvider<JmxEndpointOperation>(this.applicationContext.getEnvironment(), (EndpointDiscoverer<JmxEndpointOperation>)endpointDiscoverer, EndpointExposure.JMX);
        EndpointMBeanRegistrar endpointMBeanRegistrar = new EndpointMBeanRegistrar(mBeanServer, (EndpointObjectNameFactory)new DefaultEndpointObjectNameFactory(properties, mBeanServer, ObjectUtils.getIdentityHexString((Object)this.applicationContext)));
        return new JmxEndpointExporter(endpointProvider, endpointMBeanRegistrar, (ObjectMapper)objectMapper.getIfAvailable(ObjectMapper::new));
    }
}

