/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.health.CompositeHealthIndicatorFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.StatusEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;

@Configuration
public class HealthEndpointAutoConfiguration {
    private final HealthIndicator healthIndicator;

    public HealthEndpointAutoConfiguration(ApplicationContext applicationContext, ObjectProvider<HealthAggregator> healthAggregator) {
        this.healthIndicator = this.getHealthIndicator(applicationContext, (HealthAggregator)healthAggregator.getIfAvailable(OrderedHealthAggregator::new));
    }

    private HealthIndicator getHealthIndicator(ApplicationContext applicationContext, HealthAggregator healthAggregator) {
        LinkedHashMap indicators = new LinkedHashMap();
        indicators.putAll(applicationContext.getBeansOfType(HealthIndicator.class));
        if (ClassUtils.isPresent((String)"reactor.core.publisher.Flux", null)) {
            new ReactiveHealthIndicators().get(applicationContext).forEach(indicators::putIfAbsent);
        }
        CompositeHealthIndicatorFactory factory = new CompositeHealthIndicatorFactory();
        return factory.createHealthIndicator(healthAggregator, indicators);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    public HealthEndpoint healthEndpoint() {
        return new HealthEndpoint(this.healthIndicator);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    public StatusEndpoint statusEndpoint() {
        return new StatusEndpoint(this.healthIndicator);
    }

    private static class ReactiveHealthIndicators {
        private ReactiveHealthIndicators() {
        }

        public Map<String, HealthIndicator> get(ApplicationContext applicationContext) {
            LinkedHashMap<String, HealthIndicator> indicators = new LinkedHashMap<String, HealthIndicator>();
            applicationContext.getBeansOfType(ReactiveHealthIndicator.class).forEach((name, indicator) -> indicators.put((String)name, this.adapt((ReactiveHealthIndicator)indicator)));
            return indicators;
        }

        private HealthIndicator adapt(ReactiveHealthIndicator indicator) {
            return () -> (Health)indicator.health().block();
        }
    }
}

