/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.jdbc;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.jdbc.JdbcMetricsProperties;
import org.springframework.boot.actuate.metrics.jdbc.DataSourcePoolMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={DataSource.class, DataSourcePoolMetadataProvider.class})
@ConditionalOnProperty(value={"spring.metrics.jdbc.instrument-datasource"}, matchIfMissing=true)
@EnableConfigurationProperties(value={JdbcMetricsProperties.class})
public class DataSourcePoolMetricsConfiguration {
    private static final String DATASOURCE_SUFFIX = "dataSource";
    private final MeterRegistry registry;
    private final Collection<DataSourcePoolMetadataProvider> metadataProviders;
    private final String metricName;

    public DataSourcePoolMetricsConfiguration(MeterRegistry registry, Collection<DataSourcePoolMetadataProvider> metadataProviders, JdbcMetricsProperties jdbcMetricsProperties) {
        this.registry = registry;
        this.metadataProviders = metadataProviders;
        this.metricName = jdbcMetricsProperties.getDatasourceMetricName();
    }

    @Autowired
    public void bindDataSourcesToRegistry(Map<String, DataSource> dataSources) {
        dataSources.forEach(this::bindDataSourceToRegistry);
    }

    private void bindDataSourceToRegistry(String beanName, DataSource dataSource) {
        List tags = Tags.zip((String[])new String[]{"name", this.getDataSourceName(beanName)});
        new DataSourcePoolMetrics(dataSource, this.metadataProviders, this.metricName, (Iterable)tags).bindTo(this.registry);
    }

    private String getDataSourceName(String beanName) {
        if (beanName.length() > DATASOURCE_SUFFIX.length() && beanName.toLowerCase().endsWith(DATASOURCE_SUFFIX.toLowerCase())) {
            return beanName.substring(0, beanName.length() - DATASOURCE_SUFFIX.length());
        }
        return beanName;
    }
}

