/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.util.Collections;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;

public abstract class ManagementServerFactoryCustomizer<T extends ConfigurableWebServerFactory>
implements WebServerFactoryCustomizer<T>,
Ordered {
    private final ListableBeanFactory beanFactory;
    private final Class<? extends WebServerFactoryCustomizer<T>> customizerClass;

    protected ManagementServerFactoryCustomizer(ListableBeanFactory beanFactory, Class<? extends WebServerFactoryCustomizer<T>> customizerClass) {
        this.beanFactory = beanFactory;
        this.customizerClass = customizerClass;
    }

    public int getOrder() {
        return 0;
    }

    public final void customize(T factory) {
        ManagementServerProperties managementServerProperties = (ManagementServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ManagementServerProperties.class);
        ServerProperties serverProperties = (ServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ServerProperties.class);
        WebServerFactoryCustomizer webServerFactoryCustomizer = (WebServerFactoryCustomizer)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, this.customizerClass);
        webServerFactoryCustomizer.customize(factory);
        factory.setErrorPages(Collections.emptySet());
        this.customize(factory, managementServerProperties, serverProperties);
    }

    protected void customize(T factory, ManagementServerProperties managementServerProperties, ServerProperties serverProperties) {
        factory.setPort(managementServerProperties.getPort().intValue());
        Ssl ssl = managementServerProperties.getSsl();
        if (ssl != null) {
            factory.setSsl(ssl);
        }
        factory.setServerHeader(serverProperties.getServerHeader());
        factory.setAddress(managementServerProperties.getAddress());
        factory.addErrorPages(new ErrorPage[]{new ErrorPage(serverProperties.getError().getPath())});
    }
}

