/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import javax.servlet.Filter;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerFactoryCustomizer;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.DefaultServletWebServerFactoryCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;

@Configuration
@ManagementContextConfiguration(value=ManagementContextType.CHILD)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class ServletManagementChildContextConfiguration {
    ServletManagementChildContextConfiguration() {
    }

    @Bean
    public ServletManagementServerFactoryCustomizer serverFactoryCustomizer(ListableBeanFactory beanFactory) {
        return new ServletManagementServerFactoryCustomizer(beanFactory);
    }

    @Bean
    public UndertowAccessLogCustomizer undertowAccessLogCustomizer() {
        return new UndertowAccessLogCustomizer();
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.catalina.valves.AccessLogValve"})
    public TomcatAccessLogCustomizer tomcatAccessLogCustomizer() {
        return new TomcatAccessLogCustomizer();
    }

    static class UndertowAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
        UndertowAccessLogCustomizer() {
        }

        public void customize(UndertowServletWebServerFactory serverFactory) {
            serverFactory.setAccessLogPrefix(this.customizePrefix(serverFactory.getAccessLogPrefix()));
        }
    }

    static class TomcatAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<TomcatServletWebServerFactory> {
        TomcatAccessLogCustomizer() {
        }

        public void customize(TomcatServletWebServerFactory serverFactory) {
            AccessLogValve accessLogValve = this.findAccessLogValve(serverFactory);
            if (accessLogValve == null) {
                return;
            }
            accessLogValve.setPrefix(this.customizePrefix(accessLogValve.getPrefix()));
        }

        private AccessLogValve findAccessLogValve(TomcatServletWebServerFactory serverFactory) {
            for (Valve engineValve : serverFactory.getEngineValves()) {
                if (!(engineValve instanceof AccessLogValve)) continue;
                return (AccessLogValve)engineValve;
            }
            return null;
        }
    }

    static abstract class AccessLogCustomizer
    implements Ordered {
        AccessLogCustomizer() {
        }

        protected String customizePrefix(String prefix) {
            return "management_" + prefix;
        }

        public int getOrder() {
            return 1;
        }
    }

    static class ServletManagementServerFactoryCustomizer
    extends ManagementServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
        ServletManagementServerFactoryCustomizer(ListableBeanFactory beanFactory) {
            super(beanFactory, DefaultServletWebServerFactoryCustomizer.class);
        }

        @Override
        protected void customize(ConfigurableServletWebServerFactory webServerFactory, ManagementServerProperties managementServerProperties, ServerProperties serverProperties) {
            super.customize(webServerFactory, managementServerProperties, serverProperties);
            webServerFactory.setContextPath(managementServerProperties.getContextPath());
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableWebSecurity.class, Filter.class})
    @ConditionalOnBean(name={"springSecurityFilterChain"}, search=SearchStrategy.ANCESTORS)
    class ServletManagementContextSecurityConfiguration {
        ServletManagementContextSecurityConfiguration() {
        }

        @Bean
        public Filter springSecurityFilterChain(HierarchicalBeanFactory beanFactory) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            return (Filter)parent.getBean("springSecurityFilterChain", Filter.class);
        }
    }
}

