/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry;

import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.CloudFoundryReactiveHealthEndpointWebExtension;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.ReactiveCloudFoundryActuatorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryActuatorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryHealthEndpointWebExtension;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointWebExtension;
import org.springframework.boot.actuate.health.ReactiveHealthEndpointWebExtension;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
@AutoConfigureBefore(value={ReactiveCloudFoundryActuatorAutoConfiguration.class, CloudFoundryActuatorAutoConfiguration.class})
@AutoConfigureAfter(value={HealthEndpointAutoConfiguration.class})
public class CloudFoundryHealthWebEndpointManagementContextConfiguration {

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class ReactiveWebHealthConfiguration {
        ReactiveWebHealthConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint
        @ConditionalOnBean(value={HealthEndpoint.class, ReactiveHealthEndpointWebExtension.class})
        public CloudFoundryReactiveHealthEndpointWebExtension cloudFoundryReactiveHealthEndpointWebExtension(ReactiveHealthEndpointWebExtension reactiveHealthEndpointWebExtension) {
            return new CloudFoundryReactiveHealthEndpointWebExtension(reactiveHealthEndpointWebExtension);
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class ServletWebHealthConfiguration {
        ServletWebHealthConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint
        @ConditionalOnBean(value={HealthEndpoint.class, HealthEndpointWebExtension.class})
        public CloudFoundryHealthEndpointWebExtension cloudFoundryHealthEndpointWebExtension(HealthEndpointWebExtension healthEndpointWebExtension) {
            return new CloudFoundryHealthEndpointWebExtension(healthEndpointWebExtension);
        }
    }
}

