/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive;

import java.util.Arrays;
import java.util.Collections;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.CloudFoundryWebAnnotationEndpointDiscoverer;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.CloudFoundryReactiveHealthEndpointWebExtension;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.CloudFoundryWebFluxEndpointHandlerMapping;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.ReactiveCloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.ReactiveCloudFoundrySecurityService;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.ReactiveTokenValidator;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.EndpointPathResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.server.MatcherSecurityWebFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterChainProxy;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.WebFilter;

@Configuration
@ConditionalOnProperty(prefix="management.cloudfoundry", name={"enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
public class ReactiveCloudFoundryActuatorAutoConfiguration {
    private final ApplicationContext applicationContext;

    ReactiveCloudFoundryActuatorAutoConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Bean
    public CloudFoundryWebFluxEndpointHandlerMapping cloudFoundryWebFluxEndpointHandlerMapping(ParameterMapper parameterMapper, EndpointMediaTypes endpointMediaTypes, WebClient.Builder webClientBuilder) {
        CloudFoundryWebAnnotationEndpointDiscoverer endpointDiscoverer = new CloudFoundryWebAnnotationEndpointDiscoverer(this.applicationContext, parameterMapper, endpointMediaTypes, EndpointPathResolver.useEndpointId(), null, null, CloudFoundryReactiveHealthEndpointWebExtension.class);
        ReactiveCloudFoundrySecurityInterceptor securityInterceptor = this.getSecurityInterceptor(webClientBuilder, this.applicationContext.getEnvironment());
        return new CloudFoundryWebFluxEndpointHandlerMapping(new EndpointMapping("/cloudfoundryapplication"), endpointDiscoverer.discoverEndpoints(), endpointMediaTypes, this.getCorsConfiguration(), securityInterceptor);
    }

    private ReactiveCloudFoundrySecurityInterceptor getSecurityInterceptor(WebClient.Builder restTemplateBuilder, Environment environment) {
        ReactiveCloudFoundrySecurityService cloudfoundrySecurityService = this.getCloudFoundrySecurityService(restTemplateBuilder, environment);
        ReactiveTokenValidator tokenValidator = new ReactiveTokenValidator(cloudfoundrySecurityService);
        return new ReactiveCloudFoundrySecurityInterceptor(tokenValidator, cloudfoundrySecurityService, environment.getProperty("vcap.application.application_id"));
    }

    private ReactiveCloudFoundrySecurityService getCloudFoundrySecurityService(WebClient.Builder webClientBuilder, Environment environment) {
        String cloudControllerUrl = environment.getProperty("vcap.application.cf_api");
        return cloudControllerUrl == null ? null : new ReactiveCloudFoundrySecurityService(webClientBuilder, cloudControllerUrl);
    }

    private CorsConfiguration getCorsConfiguration() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.setAllowedMethods(Arrays.asList(HttpMethod.GET.name(), HttpMethod.POST.name()));
        corsConfiguration.setAllowedHeaders(Arrays.asList("Authorization", "X-Cf-App-Instance", "Content-Type"));
        return corsConfiguration;
    }

    private static class WebFilterChainPostProcessor
    implements BeanPostProcessor {
        private WebFilterChainPostProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof WebFilterChainProxy) {
                return this.postProcess((WebFilterChainProxy)bean);
            }
            return bean;
        }

        private WebFilterChainProxy postProcess(WebFilterChainProxy existing) {
            ServerWebExchangeMatcher cloudFoundryRequestMatcher = ServerWebExchangeMatchers.pathMatchers((String[])new String[]{"/cloudfoundryapplication/**"});
            WebFilter noOpFilter = (exchange, chain) -> chain.filter(exchange);
            MatcherSecurityWebFilterChain ignoredRequestFilterChain = new MatcherSecurityWebFilterChain(cloudFoundryRequestMatcher, Collections.singletonList(noOpFilter));
            MatcherSecurityWebFilterChain allRequestsFilterChain = new MatcherSecurityWebFilterChain(ServerWebExchangeMatchers.anyExchange(), Collections.singletonList(existing));
            return new WebFilterChainProxy(new SecurityWebFilterChain[]{ignoredRequestFilterChain, allRequestsFilterChain});
        }
    }

    @Configuration
    @ConditionalOnClass(value={MatcherSecurityWebFilterChain.class})
    static class IgnoredPathsSecurityConfiguration {
        IgnoredPathsSecurityConfiguration() {
        }

        @Bean
        public WebFilterChainPostProcessor webFilterChainPostProcessor() {
            return new WebFilterChainPostProcessor();
        }
    }
}

