/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class ExposeExcludePropertyEndpointFilter<T extends Operation>
implements EndpointFilter<T> {
    private final Class<? extends EndpointDiscoverer<T>> discovererType;
    private final Set<String> expose;
    private final Set<String> exclude;
    private final Set<String> exposeDefaults;

    public ExposeExcludePropertyEndpointFilter(Class<? extends EndpointDiscoverer<T>> discovererType, Environment environment, String prefix, String ... exposeDefaults) {
        Assert.notNull(discovererType, (String)"Discoverer Type must not be null");
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.hasText((String)prefix, (String)"Prefix must not be empty");
        Binder binder = Binder.get((Environment)environment);
        this.discovererType = discovererType;
        this.expose = this.bind(binder, prefix + ".expose");
        this.exclude = this.bind(binder, prefix + ".exclude");
        this.exposeDefaults = this.asSet(Arrays.asList(exposeDefaults));
    }

    public ExposeExcludePropertyEndpointFilter(Class<? extends EndpointDiscoverer<T>> discovererType, Collection<String> expose, Collection<String> exclude, String ... exposeDefaults) {
        Assert.notNull(discovererType, (String)"Discoverer Type must not be null");
        this.discovererType = discovererType;
        this.expose = this.asSet(expose);
        this.exclude = this.asSet(exclude);
        this.exposeDefaults = this.asSet(Arrays.asList(exposeDefaults));
    }

    private Set<String> bind(Binder binder, String name) {
        return this.asSet((Collection)binder.bind(name, Bindable.listOf(String.class)).orElseGet(ArrayList::new));
    }

    private Set<String> asSet(Collection<String> items) {
        if (items == null) {
            return Collections.emptySet();
        }
        return items.stream().map(String::toLowerCase).collect(Collectors.toCollection(HashSet::new));
    }

    public boolean match(EndpointInfo<T> info, EndpointDiscoverer<T> discoverer) {
        if (this.discovererType.isInstance(discoverer)) {
            return this.isExposed(info) && !this.isExcluded(info);
        }
        return true;
    }

    private boolean isExposed(EndpointInfo<T> info) {
        if (this.expose.isEmpty()) {
            return this.exposeDefaults.contains("*") || this.contains(this.exposeDefaults, info);
        }
        return this.expose.contains("*") || this.contains(this.expose, info);
    }

    private boolean isExcluded(EndpointInfo<T> info) {
        if (this.exclude.isEmpty()) {
            return false;
        }
        return this.exclude.contains("*") || this.contains(this.exclude, info);
    }

    private boolean contains(Set<String> items, EndpointInfo<T> info) {
        return items.contains(info.getId().toLowerCase());
    }
}

