/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointProperties;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.EndpointObjectNameFactory;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class DefaultEndpointObjectNameFactory
implements EndpointObjectNameFactory {
    private final JmxEndpointProperties properties;
    private final MBeanServer mBeanServer;
    private final String contextId;

    DefaultEndpointObjectNameFactory(JmxEndpointProperties properties, MBeanServer mBeanServer, String contextId) {
        this.properties = properties;
        this.mBeanServer = mBeanServer;
        this.contextId = contextId;
    }

    public ObjectName generate(EndpointMBean mBean) throws MalformedObjectNameException {
        String baseObjectName = this.properties.getDomain() + ":type=Endpoint,name=" + StringUtils.capitalize((String)mBean.getEndpointId());
        StringBuilder builder = new StringBuilder(baseObjectName);
        if (this.mBeanServer != null && this.hasMBean(baseObjectName)) {
            builder.append(",context=").append(this.contextId);
        }
        if (this.properties.isUniqueNames()) {
            builder.append(",identity=").append(ObjectUtils.getIdentityHexString((Object)mBean));
        }
        builder.append(this.getStaticNames());
        return ObjectNameManager.getInstance((String)builder.toString());
    }

    private boolean hasMBean(String baseObjectName) throws MalformedObjectNameException {
        ObjectName query = new ObjectName(baseObjectName + ",*");
        return !this.mBeanServer.queryNames(query, null).isEmpty();
    }

    private String getStaticNames() {
        if (this.properties.getStaticNames().isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> name : this.properties.getStaticNames().entrySet()) {
            builder.append(",").append(name.getKey()).append("=").append(name.getValue());
        }
        return builder.toString();
    }
}

