/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import javax.management.MBeanServer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.ExposeExcludePropertyEndpointFilter;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.DefaultEndpointObjectNameFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointExporter;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointProperties;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBeanRegistrar;
import org.springframework.boot.actuate.endpoint.jmx.EndpointObjectNameFactory;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperation;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxAnnotationEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMapper;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ObjectUtils;

@AutoConfigureAfter(value={JmxAutoConfiguration.class})
@EnableConfigurationProperties(value={JmxEndpointProperties.class})
@ConditionalOnProperty(name={"management.endpoints.jmx.enabled"}, matchIfMissing=true)
public class JmxEndpointAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final JmxEndpointProperties properties;

    public JmxEndpointAutoConfiguration(ApplicationContext applicationContext, JmxEndpointProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Bean
    public JmxAnnotationEndpointDiscoverer jmxAnnotationEndpointDiscoverer(ParameterMapper parameterMapper, Collection<OperationMethodInvokerAdvisor> invokerAdvisors, Collection<EndpointFilter<JmxOperation>> filters) {
        return new JmxAnnotationEndpointDiscoverer(this.applicationContext, parameterMapper, invokerAdvisors, filters);
    }

    @Bean
    @ConditionalOnSingleCandidate(value=MBeanServer.class)
    public JmxEndpointExporter jmxMBeanExporter(JmxAnnotationEndpointDiscoverer jmxAnnotationEndpointDiscoverer, MBeanServer mBeanServer, JmxAnnotationEndpointDiscoverer endpointDiscoverer, ObjectProvider<ObjectMapper> objectMapper) {
        DefaultEndpointObjectNameFactory objectNameFactory = new DefaultEndpointObjectNameFactory(this.properties, mBeanServer, ObjectUtils.getIdentityHexString((Object)this.applicationContext));
        EndpointMBeanRegistrar registrar = new EndpointMBeanRegistrar(mBeanServer, (EndpointObjectNameFactory)objectNameFactory);
        return new JmxEndpointExporter(jmxAnnotationEndpointDiscoverer, registrar, (ObjectMapper)objectMapper.getIfAvailable(ObjectMapper::new));
    }

    @Bean
    public ExposeExcludePropertyEndpointFilter<JmxOperation> jmxIncludeExcludePropertyEndpointFilter() {
        return new ExposeExcludePropertyEndpointFilter<JmxOperation>(JmxAnnotationEndpointDiscoverer.class, this.properties.getExpose(), this.properties.getExclude(), "*");
    }
}

