/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="management.endpoints.web")
public class WebEndpointProperties {
    private String basePath = "/actuator";
    private Set<String> expose = new LinkedHashSet<String>();
    private Set<String> exclude = new LinkedHashSet<String>();
    private final Map<String, String> pathMapping = new LinkedHashMap<String, String>();

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = this.cleanBasePath(basePath);
    }

    private String cleanBasePath(String basePath) {
        if (StringUtils.hasText((String)basePath) && basePath.endsWith("/")) {
            return basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }

    public Set<String> getExpose() {
        return this.expose;
    }

    public void setExpose(Set<String> expose) {
        this.expose = expose;
    }

    public Set<String> getExclude() {
        return this.exclude;
    }

    public void setExclude(Set<String> exclude) {
        this.exclude = exclude;
    }

    public Map<String, String> getPathMapping() {
        return this.pathMapping;
    }
}

